/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.entities.villager.SkyVillagerTrades;
import com.legacy.blue_skies.entities.villager.tasks.GatekeeperTasks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LongSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GatekeeperEntity
extends AbstractVillagerEntity
implements IRangedAttackMob {
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_220955_p, (Object[])new MemoryModuleType[]{MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y});
    private static final ImmutableList<SensorType<? extends Sensor<? super GatekeeperEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_221000_d, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<GatekeeperEntity, PointOfInterestType>> VALID_POI = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (entity, type) -> type == PointOfInterestType.field_221069_q, (Object)MemoryModuleType.field_220943_d, (entity, type) -> type == PointOfInterestType.field_221070_r);

    public GatekeeperEntity(EntityType<? extends GatekeeperEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedBowAttackGoal(this, this, 0.65, 10, 15.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, mob -> mob instanceof IMob && !(mob instanceof CreeperEntity)));
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return super.func_213348_b(poseIn, sizeIn);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ItemStack bow = new ItemStack((IItemProvider)Items.field_151031_f);
        bow.func_77966_a(Enchantments.field_185309_u, 1);
        this.func_184201_a(EquipmentSlotType.MAINHAND, bow);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.func_70638_az() == null && this.field_70737_aN == 0) {
            this.func_184185_a(SoundEvents.field_187719_p, 1.2f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_184185_a(SoundEvents.field_187913_gm, 1.0f, this.func_70647_i());
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.resetBrain((ServerWorld)this.field_70170_p);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        super.func_70619_bc();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70608_bn() ? null : (this.func_213716_dX() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected SoundEvent func_213721_r(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    public GatekeeperEntity createChild(AgeableEntity ageable) {
        return null;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (itemstack.func_77973_b() != SkiesItems.gatekeeper_spawn_egg && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_213713_b(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] tradeList = (VillagerTrades.ITrade[])SkyVillagerTrades.GATEKEEPER_OFFERS.get(1);
        if (tradeList != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, tradeList, 1);
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.removePOI((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b);
        this.removePOI((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
    }

    public void removePOI(MemoryModuleType<GlobalPos> module) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(module).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_218177_a());
                PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                BiPredicate<GatekeeperEntity, PointOfInterestType> bipredicate = VALID_POI.get(module);
                if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)optional.get())) {
                    pointofinterestmanager.func_219142_b(p_213752_3_.func_218180_b());
                    DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                }
            });
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof VillagerEntity || entityIn instanceof IronGolemEntity || entityIn instanceof GatekeeperEntity) {
            return true;
        }
        return this.func_184194_a(entityIn.func_96124_cp());
    }

    public boolean canBreed() {
        return this.func_70874_b() == 0;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public Brain<GatekeeperEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = new Brain(MEMORY_TYPES, SENSOR_TYPES, dynamicIn);
        this.initBrain((Brain<GatekeeperEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerWorld p_213770_1_) {
        Brain<GatekeeperEntity> brain = this.func_213375_cj();
        brain.func_218227_b(p_213770_1_, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain(this.func_213375_cj());
    }

    private void initBrain(Brain<GatekeeperEntity> villagerBrain) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        villagerBrain.func_218203_a(Schedule.field_221386_d);
        villagerBrain.func_218208_a(Activity.field_221365_a, GatekeeperTasks.core(f));
        villagerBrain.func_218208_a(Activity.field_221369_e, GatekeeperTasks.rest(f));
        villagerBrain.func_218208_a(Activity.field_221366_b, GatekeeperTasks.idle(f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    public void func_213342_e(BlockPos pos) {
        super.func_213342_e(pos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmPose getArmPose() {
        return this.func_213398_dR() ? ArmPose.BOW_AND_ARROW : ArmPose.CROSSED;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customeArrow(abstractarrowentity);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    class RangedBowAttackGoal<T extends GatekeeperEntity>
    extends Goal {
        private final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ GatekeeperEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedBowAttackGoal(T t, double attackCooldownIn, int n, float f) {
            void maxAttackDistanceIn;
            void mob;
            this.this$0 = (GatekeeperEntity)this$0;
            this.entity = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.attackCooldown = (int)attackCooldownIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setAttackCooldown(int p_189428_1_) {
            this.attackCooldown = p_189428_1_;
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() == null ? false : this.isBowInMainhand();
        }

        protected boolean isBowInMainhand() {
            ItemStack main = this.entity.func_184614_ca();
            ItemStack off = this.entity.func_184592_cb();
            return main.func_77973_b() instanceof BowItem || off.func_77973_b() instanceof BowItem;
        }

        public boolean func_75253_b() {
            return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowInMainhand();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.entity.func_213395_q(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.entity.func_213395_q(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.entity.func_184602_cy();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.entity.func_70092_e(livingentity.field_70165_t, livingentity.func_174813_aQ().field_72338_b, livingentity.field_70161_v);
                boolean flag = this.entity.func_70635_at().func_75522_a((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.entity.func_184587_cr()) {
                    int i;
                    if (!flag && this.seeTime < -60) {
                        this.entity.func_184602_cy();
                    } else if (flag && (i = this.entity.func_184612_cw()) >= 20) {
                        this.entity.func_184602_cy();
                        this.entity.func_82196_d(livingentity, BowItem.func_185059_b((int)i));
                        this.attackTime = this.attackCooldown;
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                    this.entity.func_184598_c(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_151031_f));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        CROSSED,
        ATTACKING,
        BOW_AND_ARROW;

    }
}

