/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.entities.hostile.VenomSpiderEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class VenomSpitEntity
extends Entity
implements IProjectile {
    public VenomSpiderEntity owner;
    private CompoundNBT ownerNbt;

    public VenomSpitEntity(EntityType<? extends VenomSpitEntity> type, World world) {
        super(type, world);
    }

    public VenomSpitEntity(World worldIn, VenomSpiderEntity spider) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        this.owner = spider;
        this.func_70107_b(spider.field_70165_t - (double)(spider.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(spider.field_70761_aq * ((float)Math.PI / 180))), spider.field_70163_u + (double)spider.func_70047_e() - (double)0.1f, spider.field_70161_v + (double)(spider.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(spider.field_70761_aq * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public VenomSpitEntity(World worldIn, double x, double y, double z, double xDir, double yDir, double zDir) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, xDir * d0, yDir, zDir * d0);
        }
        this.func_213293_j(xDir, yDir, zDir);
    }

    public VenomSpitEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.VENOM_SPIT, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ownerNbt != null) {
            this.restoreOwnerFromSave();
        }
        Vec3d vec3d = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(vec3d).func_186662_g(1.0), p_213879_1_ -> !p_213879_1_.func_175149_v() && p_213879_1_ != this.owner, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        this.field_70165_t += vec3d.field_72450_a;
        this.field_70163_u += vec3d.field_72448_b;
        this.field_70161_v += vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)VenomSpitEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(vec3d.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < 6; ++i) {
            float dx = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
            float dy = this.field_70146_Z.nextFloat() / 10.0f;
            float dz = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
            this.field_70170_p.func_195594_a((IParticleData)new PoisonData(false), (double)this.func_180425_c().func_177958_n() + 0.5, (double)((float)this.func_180425_c().func_177956_o() + 0.5f), (double)this.func_180425_c().func_177952_p() + 0.5, (double)dx, (double)dy, (double)dz);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)VenomSpitEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void onHit(RayTraceResult p_190536_1_) {
        RayTraceResult.Type raytraceresult$type = p_190536_1_.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY && this.owner != null) {
            ((EntityRayTraceResult)p_190536_1_).func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.owner).func_76349_b(), 1.0f);
            if (((EntityRayTraceResult)p_190536_1_).func_216348_a() instanceof LivingEntity) {
                int durration = 20 * (this.field_70170_p.func_175659_aa().func_151525_a() + 3);
                int amplifier = this.field_70170_p.func_175659_aa().func_151525_a() / 2;
                ((LivingEntity)((EntityRayTraceResult)p_190536_1_).func_216348_a()).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
            }
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.ownerNbt = compound.func_74775_l("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.owner != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            UUID uuid = this.owner.func_110124_au();
            compoundnbt.func_186854_a("OwnerUUID", uuid);
            compound.func_218657_a("Owner", (INBT)compoundnbt);
        }
    }

    private void restoreOwnerFromSave() {
        if (this.ownerNbt != null && this.ownerNbt.func_186855_b("OwnerUUID")) {
            UUID uuid = this.ownerNbt.func_186857_a("OwnerUUID");
            for (VenomSpiderEntity spider : this.field_70170_p.func_217357_a(VenomSpiderEntity.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!spider.func_110124_au().equals(uuid)) continue;
                this.owner = spider;
                break;
            }
        }
        this.ownerNbt = null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

