/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluctuantSphereEntity
extends DamagingProjectileEntity {
    public FluctuantSphereEntity(EntityType<? extends FluctuantSphereEntity> type, World world) {
        super(type, world);
    }

    public FluctuantSphereEntity(World worldIn, SummonerEntity summoner) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, worldIn);
        this.field_70235_a = summoner;
        this.func_70107_b(summoner.field_70165_t - (double)(summoner.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(summoner.field_70761_aq * ((float)Math.PI / 180))), summoner.field_70163_u + (double)summoner.func_70047_e() - (double)0.1f, summoner.field_70161_v + (double)(summoner.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(summoner.field_70761_aq * ((float)Math.PI / 180))));
    }

    public FluctuantSphereEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.FLUCTUANT_SPHERE, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluctuantSphereEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public FluctuantSphereEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(SkiesEntityTypes.FLUCTUANT_SPHERE, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY && this.field_70235_a != null) {
            ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.field_70235_a).func_76349_b(), 1.0f);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K && this.field_70173_aa > 20 || this.field_70173_aa >= 100) {
            this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_180425_c(), SoundEvents.field_193788_dg, SoundCategory.HOSTILE, 1.0f, 2.0f);
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d3 = 10.0;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d2 * d3, d0, d1, d2);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g((double)1.2f)));
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity) || entity == this.field_70235_a || entity instanceof ISkyBossMob || entity instanceof IllusionerEntity) continue;
            entity.func_70097_a(new EntityDamageSource("fluctuant_sphere", (Entity)this.field_70235_a).func_82726_p(), 1.0f);
            if (!this.field_70170_p.field_72995_K) continue;
            World worldObj = this.field_70170_p;
            double sphereX = entity.field_70165_t;
            double sphereY = (entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b) / 2.0 + entity.func_174813_aQ().field_72338_b;
            double sphereZ = entity.field_70161_v;
            double targetX = this.field_70165_t;
            double targetY = this.field_70163_u - (double)0.6f;
            double targetZ = this.field_70161_v;
            double xDifference = targetX - entity.field_70165_t;
            double yDifference = targetY - entity.field_70163_u;
            double zDifference = targetZ - entity.field_70161_v;
            double length = Math.sqrt(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference);
            double difX = xDifference / (length * 1.0);
            yDifference /= length * 1.0;
            double veldif = difX / xDifference;
            double velcur = 1.0;
            double randX = difX * worldObj.field_73012_v.nextDouble();
            double randZ = (zDifference /= length * 1.0) * worldObj.field_73012_v.nextDouble();
            for (int i = 0; i < 7; ++i) {
                while (Math.signum(difX) == 1.0 ? sphereX < targetX : sphereX > targetX) {
                    this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197622_o, true, sphereX + randX, sphereY, sphereZ + randZ, entity.func_213322_ci().func_82615_a() * velcur, entity.func_213322_ci().func_82617_b() * velcur, entity.func_213322_ci().func_82616_c() * velcur);
                    sphereX += difX;
                    sphereY += yDifference;
                    sphereZ += zDifference;
                    velcur -= veldif;
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected float func_82341_c() {
        return 0.7f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

