/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class StardustRamEntity
extends SheepEntity {
    private EatSkyGrassGoal eatGrassGoal;
    private int sheepTimer;

    public StardustRamEntity(EntityType<? extends StardustRamEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.eatGrassGoal = new EatSkyGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.corn}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == SkiesItems.corn || super.func_70877_b(stack);
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.3f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f;
    }

    public SheepEntity func_90011_a(AgeableEntity ageable) {
        return (SheepEntity)SkiesEntityTypes.STARDUST_RAM.func_200721_a(this.field_70170_p);
    }

    class EatSkyGrassGoal
    extends Goal {
        private final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)SkiesBlocks.turquoise_grass);
        private final MobEntity grassEaterEntity;
        private final World entityWorld;
        private int eatingGrassTimer;

        public EatSkyGrassGoal(MobEntity grassEaterEntityIn) {
            this.grassEaterEntity = grassEaterEntityIn;
            this.entityWorld = grassEaterEntityIn.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (this.grassEaterEntity.func_70681_au().nextInt(this.grassEaterEntity.func_70631_g_() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = new BlockPos((Entity)this.grassEaterEntity);
            if (this.IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
                return true;
            }
            return this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_177230_c() == SkiesBlocks.turquoise_grass_block;
        }

        public void func_75249_e() {
            this.eatingGrassTimer = 40;
            this.entityWorld.func_72960_a((Entity)this.grassEaterEntity, (byte)10);
            this.grassEaterEntity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.eatingGrassTimer = 0;
        }

        public boolean func_75253_b() {
            return this.eatingGrassTimer > 0;
        }

        public int getEatingGrassTimer() {
            return this.eatingGrassTimer;
        }

        public void func_75246_d() {
            this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
            if (this.eatingGrassTimer == 4) {
                BlockPos blockpos = new BlockPos((Entity)this.grassEaterEntity);
                if (this.IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.grassEaterEntity)) {
                        this.entityWorld.func_175655_b(blockpos, false);
                    }
                    this.grassEaterEntity.func_70615_aA();
                } else {
                    BlockPos blockpos1 = blockpos.func_177977_b();
                    if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == SkiesBlocks.turquoise_grass_block) {
                        if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.grassEaterEntity)) {
                            this.entityWorld.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)SkiesBlocks.turquoise_grass_block.func_176223_P()));
                            this.entityWorld.func_180501_a(blockpos1, SkiesBlocks.turquoise_dirt.func_176223_P(), 2);
                        }
                        this.grassEaterEntity.func_70615_aA();
                    }
                }
            }
        }
    }
}

