/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.mojang.datafixers.DataFixer;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class DecayingSpikeEntity
extends FallingBlockEntity {
    public static final DataParameter<Boolean> DOWNWARD = EntityDataManager.func_187226_a(DecayingSpikeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockState state = this.getDownwards() ? (BlockState)SkiesBlocks.decaying_spike.func_176223_P().func_206870_a((IProperty)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)) : SkiesBlocks.decaying_spike.func_176223_P();
    private int timeExisted = 0;
    public boolean upward;
    private LivingEntity caster;
    private UUID casterUuid;

    public DecayingSpikeEntity(EntityType<? extends DecayingSpikeEntity> type, World worldIn) {
        super(SkiesEntityTypes.DECAYING_SPIKE, worldIn);
    }

    public DecayingSpikeEntity(World world, BlockPos pos, BlockState state, LivingEntity casterIn) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
        this.field_70156_m = true;
        this.setCaster(casterIn);
        this.setState(state);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public DecayingSpikeEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70170_p.field_72995_K && (this.state == null || this.state == Blocks.field_150350_a.func_176223_P())) {
            this.state = this.field_70170_p.func_180495_p(this.func_180425_c());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DOWNWARD, (Object)true);
    }

    public void func_70071_h_() {
        if (this.func_195054_l() == null) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        ++this.timeExisted;
        if (!this.func_189652_ae() || !this.upward) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Block block = SkiesBlocks.decaying_spike;
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            if (!this.field_70122_E) {
                if (this.timeExisted > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.timeExisted > 600 || !this.getDownwards() && this.timeExisted >= 15) {
                    this.func_70106_y();
                }
            } else {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos1);
                if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)) && FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                    this.field_70122_E = false;
                    return;
                }
                if (blockstate.func_177230_c() != Blocks.field_196603_bb) {
                    this.func_70106_y();
                    boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                    boolean flag3 = this.state.func_196955_c((IWorldReader)this.field_70170_p, blockpos1);
                    if (flag2 && flag3) {
                        if (this.state.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(blockpos1).func_206886_c() == Fluids.field_204546_a) {
                            this.state = (BlockState)this.state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                        }
                        if (this.field_70170_p.func_180501_a(blockpos1, this.state, 3)) {
                            TileEntity tileentity;
                            if (block instanceof FallingBlock) {
                                ((FallingBlock)block).func_176502_a_(this.field_70170_p, blockpos1, this.state, blockstate);
                            }
                            if (this.field_145810_d != null && this.state.hasTileEntity() && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                                for (String s : this.field_145810_d.func_150296_c()) {
                                    INBT inbt = this.field_145810_d.func_74781_a(s);
                                    if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                    compoundnbt.func_218657_a(s, inbt.func_74737_b());
                                }
                                tileentity.func_145839_a(compoundnbt);
                                tileentity.func_70296_d();
                            }
                        } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                    } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                        this.func_199703_a((IItemProvider)block);
                    }
                    if (block instanceof FallingBlock) {
                        ((FallingBlock)block).func_190974_b(this.field_70170_p, blockpos1);
                    }
                }
            }
            if (this.func_213322_ci().func_82617_b() != 0.0) {
                ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
                for (Entity entity : list) {
                    this.damage(entity, 0.0f);
                }
            }
        }
        if (this.timeExisted > 100) {
            this.func_70106_y();
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            for (Entity entity : list) {
                this.damage(entity, 1.0f);
            }
        }
    }

    private void damage(Entity hitEntityIn, float amp) {
        LivingEntity caster = this.getCaster();
        if (hitEntityIn.func_70089_S() && !hitEntityIn.func_190530_aW() && hitEntityIn != caster) {
            if (caster == null) {
                hitEntityIn.func_70097_a(new DamageSource("rock_stab").func_76348_h().func_76349_b(), 5.0f + amp);
            } else {
                if (caster.func_184191_r(hitEntityIn)) {
                    return;
                }
                hitEntityIn.func_70097_a(new EntityDamageSource("rock_stab_mob", (Entity)caster).func_76348_h().func_76349_b(), 5.0f + amp);
            }
        }
    }

    public static void registerFixesDecayingFallingBlock(DataFixer fixer) {
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public BlockState func_195054_l() {
        return this.state;
    }

    public boolean getDownwards() {
        return (Boolean)this.field_70180_af.func_187225_a(DOWNWARD);
    }

    public void setDownwards(boolean downwardIn) {
        this.field_70180_af.func_187227_b(DOWNWARD, (Object)downwardIn);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setDownwards(compound.func_74767_n("Downward"));
        this.state = Block.func_196257_b((int)compound.func_74762_e("blockstateId"));
        this.casterUuid = compound.func_186857_a("OwnerUUID");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("Downward", this.getDownwards());
        compound.func_74768_a("blockstateId", Block.func_196246_j((BlockState)this.state));
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

