/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.legacy.blue_skies.entities.util.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArtificialGolemEntity
extends MonsterEntity
implements ISkyBossMob,
IRangedAttackMob {
    private final RangedBowAttackGoal<ArtificialGolemEntity> aiArrowAttack = new RangedBowAttackGoal((MonsterEntity)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.0, true){

        public void func_75251_c() {
            super.func_75251_c();
            ArtificialGolemEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            ArtificialGolemEntity.this.func_213395_q(true);
        }
    };
    private int attackTimer;
    private LivingEntity caster;
    private UUID casterUuid;
    public static final DataParameter<Boolean> PHASE_TWO = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ARCHER = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ArtificialGolemEntity(EntityType<? extends ArtificialGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 0;
    }

    public ArtificialGolemEntity(World worldIn, LivingEntity casterIn) {
        this(SkiesEntityTypes.ARTIFICIAL_GOLEM, worldIn);
        this.setCaster(casterIn);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.func_180483_b(difficulty);
        this.func_180481_a(difficulty);
        this.setCombatTask();
        return spawnDataIn;
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f));
            if (itemstack.func_77973_b() instanceof BowItem) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.func_189428_b(i);
                this.field_70714_bg.func_75776_a(1, this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(1, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PHASE_TWO, (Object)this.phaseTwoQualified());
        this.field_70180_af.func_187214_a(ARCHER, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.getPhaseTwo() && !this.isArcher()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        }
        if (this.isArcher()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            this.func_70624_b((LivingEntity)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_175446_cd()) {
            return;
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.func_70638_az() == null && this.field_70173_aa > 50 && !this.field_70170_p.field_72995_K) {
            this.func_70656_aK();
            this.func_70106_y();
        } else if (this.func_70638_az() != null) {
            if (!this.func_70638_az().func_70089_S() || this.func_70638_az().func_110143_aJ() == 0.0f) {
                this.func_70656_aK();
                this.func_70106_y();
            }
            if (!(this.getCaster() == null || this.getCaster().func_70089_S() && this.getCaster().func_110143_aJ() != 0.0f)) {
                this.func_70656_aK();
                this.func_70106_y();
            }
        } else if (!this.func_70605_aq().func_75640_a() && this.field_70173_aa > 100 && !this.field_70170_p.field_72995_K) {
            this.func_70656_aK();
            this.func_70106_y();
        }
    }

    public void func_70020_e(CompoundNBT tagCompound) {
        super.func_70020_e(tagCompound);
        this.casterUuid = tagCompound.func_186857_a("OwnerUUID");
        this.setPhaseTwo(tagCompound.func_74767_n("PhaseTwo"));
        this.setArcher(tagCompound.func_74767_n("IsArcher"));
        this.setAttacking(tagCompound.func_74767_n("GolemAttacking"));
        this.setCombatTask();
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        super.func_213281_b(tagCompound);
        if (this.casterUuid != null) {
            tagCompound.func_186854_a("OwnerUUID", this.casterUuid);
        }
        tagCompound.func_74757_a("PhaseTwo", this.getPhaseTwo());
        tagCompound.func_74757_a("IsArcher", this.isArcher());
        tagCompound.func_74757_a("GolemAttacking", this.getAttacking());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.attackTimer = 10;
            float damage = this.getPhaseTwo() ? 3.5f : 2.5f;
            boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76351_m(), damage);
            if (flag) {
                this.func_174815_a((LivingEntity)this, entityIn);
            }
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            return flag;
        }
        return super.func_70652_k(entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource && (source.func_76346_g() instanceof SpellcastingIllagerEntity || source.func_76346_g() instanceof ArtificialGolemEntity)) {
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
        } else {
            this.setAttacking(false);
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223225_d_;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public void setArcher(boolean archer) {
        this.field_70180_af.func_187227_b(ARCHER, (Object)archer);
    }

    public boolean isArcher() {
        return (Boolean)this.field_70180_af.func_187225_a(ARCHER);
    }

    public void setAttacking(boolean att) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)att);
    }

    public boolean getAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setPhaseTwo(boolean phaseTwo) {
        if (phaseTwo && !this.isArcher()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        }
        this.field_70180_af.func_187227_b(PHASE_TWO, (Object)phaseTwo);
    }

    public boolean getPhaseTwo() {
        return (Boolean)this.field_70180_af.func_187225_a(PHASE_TWO);
    }

    public boolean phaseTwoQualified() {
        return this.getCaster() != null && this.getCaster().func_110143_aJ() == this.getCaster().func_110143_aJ() / this.getCaster().func_110138_aP();
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.isArcher()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customeArrow(abstractarrowentity);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity fireArrow(ItemStack p_213624_1_, float p_213624_2_) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)p_213624_1_, (float)p_213624_2_);
    }
}

