/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.entities.hostile.NyctoflyEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.StrangeLightningEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.entities.util.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SummonerEntity
extends SpellcastingIllagerEntity
implements ISkyBossMob {
    public static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(SummonerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_HOME = EntityDataManager.func_187226_a(SummonerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(SummonerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186742_b(true);
    private int teleportCooldown;
    private int timeSinceFighting;
    public double homeX;
    public double homeY;
    public double homeZ;
    public boolean golemsChanged = false;

    public SummonerEntity(EntityType<? extends SummonerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonArcherGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SummonGolemGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SphereAttackGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new RegenGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(350.0);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_213644_t(reason == SpawnReason.SPAWN_EGG);
        if (reason == SpawnReason.TRIGGERED) {
            this.field_70170_p.func_175655_b(this.func_180425_c(), false);
            this.field_70170_p.func_175655_b(this.func_180425_c().func_177984_a(), false);
        }
        return spawnDataIn;
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_213315_a(MoverType type, Vec3d vec) {
        if (this.getInvulTime() <= 0) {
            super.func_213315_a(type, vec);
        } else {
            super.func_213315_a(type, new Vec3d(0.0, vec.field_72448_b, 0.0));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(HAS_HOME, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    public boolean hasHome() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_HOME);
    }

    public void setHasHome(boolean hasHome) {
        this.field_70180_af.func_187227_b(HAS_HOME, (Object)hasHome);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setDungeonSpawned(compound.func_74767_n("DungeonSpawned"));
        this.setHasHome(compound.func_74767_n("HasHome"));
        this.setInvulTime(compound.func_74762_e("Invul"));
        this.homeX = compound.func_74769_h("HomeX");
        this.homeY = compound.func_74769_h("HomeY");
        this.homeZ = compound.func_74769_h("HomeZ");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a("HomeX", this.homeX);
        compound.func_74780_a("HomeY", this.homeY);
        compound.func_74780_a("HomeZ", this.homeZ);
        this.setInvulTime(compound.func_74762_e("Invul"));
        compound.func_74757_a("DungeonSpawned", this.isDungeonSpawned());
        compound.func_74757_a("HasHome", this.hasHome());
    }

    public void setHome(double posX, double posY, double posZ) {
        this.homeX = posX;
        this.homeY = posY;
        this.homeZ = posZ;
    }

    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a() == Effects.field_76436_u ? false : (effect.func_188419_a() == Effects.field_76433_i ? false : (effect.func_188419_a() == Effects.field_82731_v ? false : super.func_70687_e(effect)));
    }

    public boolean func_213392_I() {
        return true;
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.func_70638_az() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.field_70146_Z.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    public boolean secondPhaseHealth() {
        return this.func_110143_aJ() <= 175.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.secondPhaseHealth()) {
            double dx = this.field_70146_Z.nextGaussian() * 0.02;
            double dy = this.field_70146_Z.nextGaussian() * 0.02;
            double dz = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)SkiesParticles.BLUE_FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
        } else {
            this.spawnParticles((IParticleData)ParticleTypes.field_197629_v);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() > 0.7) {
            this.healthParticles();
        }
        if (!this.field_70170_p.field_72995_K) {
            List list;
            if (!this.func_193082_dl() && this.func_70090_H() || !this.func_193082_dl() && this.func_180799_ab()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.func_175446_cd()) {
                PlayerEntity player;
                if (this.hasHome()) {
                    this.checkIfHome();
                }
                if (this.func_70638_az() instanceof PlayerEntity && !(player = (PlayerEntity)this.func_70638_az()).func_70089_S()) {
                    this.func_70634_a(this.homeX, this.homeY, this.homeZ);
                }
                ++this.teleportCooldown;
            }
            if (this.func_110143_aJ() != this.func_110138_aP() && this.timeSinceFighting >= 30 && this.isDungeonSpawned() && (list = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 1.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.func_70638_az() != null) {
                if ((this.func_70638_az() instanceof PlayerEntity && this.func_70638_az().func_110143_aJ() == 0.0f || this.func_70638_az() instanceof PlayerEntity && !this.func_70638_az().func_70089_S() && this.isDungeonSpawned()) && !(list = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 5.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                    this.func_70691_i(30.0f);
                }
                this.timeSinceFighting = 0;
            }
            if (this.field_70737_aN > 0) {
                this.timeSinceFighting = 0;
            }
            if (this.func_70638_az() == null && this.timeSinceFighting <= 101) {
                ++this.timeSinceFighting;
            }
        }
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 1) {
            if (this.isDungeonSpawned() && this.hasHome()) {
                this.field_70170_p.func_180501_a(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ), SkiesBlocks.bright_blinding_keystone.func_176223_P(), 2);
                this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ), SkiesBlocks.blinding_stone.func_176223_P());
                TileEntity keystone = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ));
                if (keystone instanceof KeystoneTileEntity) {
                    ((KeystoneTileEntity)keystone).setTeleportOffset(new BlockPos(0, -9, 5));
                    ((KeystoneTileEntity)keystone).setSpawnsBoss(false);
                    ((KeystoneTileEntity)keystone).setKeysRequired(false);
                }
            }
            DyeColor dyecolor = DyeColor.PURPLE;
            ItemStack itemstack = this.makeFirework(dyecolor, 0);
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
            this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
        }
    }

    private ItemStack makeFirework(DyeColor color, int flightTime) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, 1);
        ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = itemstack1.func_190925_c("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(color.func_196060_f());
        compoundnbt.func_197646_b("Colors", (List)list);
        ArrayList fadelist = Lists.newArrayList();
        fadelist.add(DyeColor.LIME.func_196060_f());
        compoundnbt.func_197646_b("FadeColors", (List)fadelist);
        compoundnbt.func_74774_a("Type", (byte)FireworkRocketItem.Shape.LARGE_BALL.func_196071_a());
        CompoundNBT compoundnbt1 = itemstack.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        compoundnbt.func_74757_a("Flicker", true);
        CompoundNBT compoundnbt2 = itemstack1.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.func_74774_a("Flight", (byte)flightTime);
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return itemstack;
    }

    public void func_70636_d() {
        List playerCount;
        super.func_70636_d();
        if (this.func_70638_az() != null && ((playerCount = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(4.0))).size() > 0 && this.func_70638_az() instanceof PlayerEntity || (double)this.func_70032_d((Entity)this.func_70638_az()) <= 5.0) && !this.func_193082_dl()) {
            this.teleportAround();
        }
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 2.0f, 1.0f);
            }
            double d0 = 0.05;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.5, 0.0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, -d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, -d0);
            }
        }
        List summonedGolems = this.field_70170_p.func_217357_a(ArtificialGolemEntity.class, new AxisAlignedBB(new BlockPos(this.homeX, this.homeY, this.homeZ)).func_72314_b(35.0, 15.0, 35.0));
        if (this.secondPhaseHealth() && !this.golemsChanged) {
            for (ArtificialGolemEntity golems : summonedGolems) {
                golems.setPhaseTwo(true);
            }
            this.golemsChanged = true;
        } else if (!this.secondPhaseHealth() && this.golemsChanged) {
            for (ArtificialGolemEntity golems : summonedGolems) {
                golems.setPhaseTwo(false);
            }
            this.golemsChanged = false;
        }
    }

    public void checkIfHome() {
        int distance = 15;
        if (this.field_70165_t > this.homeX + (double)distance || this.field_70161_v > this.homeZ + (double)distance || this.field_70163_u > this.homeY + 10.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), SkiesBlocks.turquoise_stonebrick.func_176223_P());
        } else if (this.field_70165_t < this.homeX - (double)distance || this.field_70161_v < this.homeZ - (double)distance || this.field_70163_u < this.homeY - 5.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), SkiesBlocks.turquoise_stonebrick.func_176223_P());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource && (source.func_76346_g() instanceof SpellcastingIllagerEntity || source.func_76346_g() instanceof ArtificialGolemEntity)) {
            this.teleportAround();
            return false;
        }
        if (source instanceof IndirectEntityDamageSource && !this.func_193082_dl()) {
            this.teleportAround();
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            return false;
        }
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            ItemStack stack = player.field_71071_by.func_70448_g();
            boolean isMudkip = stack.func_77973_b().getRegistryName().toString().contains("mudkip");
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (isMudkip) {
                return false;
            }
            if (!source.func_180136_u() && !source.func_76352_a() && (double)source.func_76346_g().func_70032_d((Entity)this) > 3.5) {
                return false;
            }
            return super.func_70097_a(source, Math.min(21.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void teleportAround() {
        if (this.getInvulTime() <= 0) {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            for (int i = 0; i < 16; ++i) {
                double d3 = this.field_70165_t + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                double d4 = MathHelper.func_151237_a((double)(this.field_70163_u + (double)(this.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(this.field_70170_p.func_72940_L() - 1));
                double d5 = this.field_70161_v + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                if (this.func_184187_bx() != null) {
                    this.func_184210_p();
                }
                if (this.isDungeonSpawned()) {
                    if (!this.attemptDungeonTeleport(d3, d4, d5)) continue;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                    this.func_70656_aK();
                    break;
                }
                if (!this.func_213373_a(d3, d4, d5, true)) continue;
                this.field_70170_p.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                this.func_70656_aK();
                break;
            }
        }
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && (double)blockpos.func_177956_o() > this.homeY - 3.0 && (double)blockpos.func_177956_o() <= this.homeY + 1.0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate == SkiesBlocks.turquoise_stonebrick.func_176223_P() || iblockstate == SkiesBlocks.mossy_turquoise_stonebrick.func_176223_P() || iblockstate == SkiesBlocks.cracked_turquoise_stonebrick.func_176223_P()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_217345_j((Entity)this)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.func_213302_cg();
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d3, d4, d5, (double)f, (double)f1, (double)f2);
        }
        if (this instanceof CreatureEntity) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof DecayingSpikeEntity) {
            return this.func_184191_r((Entity)((DecayingSpikeEntity)entityIn).getCaster());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_SUMMONER_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SUMMONER_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_SUMMONER_HURT;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.9f;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles(IParticleData particleType) {
        double dx = this.field_70146_Z.nextGaussian() * 0.02;
        double dy = this.field_70146_Z.nextGaussian() * 0.02;
        double dz = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_195594_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public SoundEvent func_213654_dW() {
        return SkiesSounds.ENTITY_SUMMONER_CELEBRATE;
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_SUMMONER_CAST_SPELL;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SummonerEntity.this.getInvulTime() > 0;
        }
    }

    public class RegenGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        public RegenGoal() {
            super((SpellcastingIllagerEntity)SummonerEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (!SummonerEntity.this.secondPhaseHealth()) {
                return false;
            }
            return SummonerEntity.this.func_70638_az() == null || !((double)SummonerEntity.this.func_70032_d((Entity)SummonerEntity.this.func_70638_az()) < 5.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int playerCount = SummonerEntity.this.field_70170_p.func_217357_a(PlayerEntity.class, SummonerEntity.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (playerCount < 2) {
                SummonerEntity.this.func_195064_c(new EffectInstance(Effects.field_76428_l, 45, 4, false, false));
            } else {
                SummonerEntity.this.func_195064_c(new EffectInstance(Effects.field_76428_l, 25, 5, false, false));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 70;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_REGEN;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    class SummonArcherGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private SummonArcherGoal() {
            super((SpellcastingIllagerEntity)SummonerEntity.this);
        }

        public boolean func_75250_a() {
            int golemCount = 0;
            int archerCount = 0;
            List archers = SummonerEntity.this.field_70170_p.func_217357_a(ArtificialGolemEntity.class, SummonerEntity.this.func_174813_aQ().func_186662_g(35.0));
            for (ArtificialGolemEntity golem : archers) {
                if (golem.isArcher()) {
                    ++archerCount;
                    continue;
                }
                if (golem.isArcher()) continue;
                ++golemCount;
            }
            if (!super.func_75250_a()) {
                return false;
            }
            if (SummonerEntity.this.getInvulTime() > 0) {
                return false;
            }
            return archerCount == 0 && golemCount <= 1;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            for (int i = 0; i < 2; ++i) {
                BlockPos pos = !SummonerEntity.this.isDungeonSpawned() ? SummonerEntity.this.func_180425_c() : new BlockPos(SummonerEntity.this.homeX, SummonerEntity.this.homeY, SummonerEntity.this.homeZ);
                BlockPos spawnPos = new BlockPos(pos.func_177958_n() + -6 + SummonerEntity.this.field_70146_Z.nextInt(12), pos.func_177956_o(), pos.func_177952_p() + -6 + SummonerEntity.this.field_70146_Z.nextInt(12));
                ArtificialGolemEntity archer = new ArtificialGolemEntity(SummonerEntity.this.field_70170_p, (LivingEntity)SummonerEntity.this);
                archer.func_174828_a(spawnPos, 0.0f, 0.0f);
                archer.setArcher(true);
                archer.setCombatTask();
                archer.func_213386_a((IWorld)SummonerEntity.this.field_70170_p, SummonerEntity.this.field_70170_p.func_175649_E(spawnPos), SpawnReason.MOB_SUMMONED, null, null);
                archer.func_70624_b(SummonerEntity.this.func_70638_az());
                SummonerEntity.this.field_70170_p.func_217376_c((Entity)archer);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }

    class SummonGolemGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private SummonGolemGoal() {
            super((SpellcastingIllagerEntity)SummonerEntity.this);
        }

        public boolean func_75250_a() {
            int i = SummonerEntity.this.field_70170_p.func_217357_a(ArtificialGolemEntity.class, SummonerEntity.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (!super.func_75250_a()) {
                return false;
            }
            if (SummonerEntity.this.getInvulTime() > 0) {
                return false;
            }
            if (i >= 3) {
                return false;
            }
            return SummonerEntity.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            block4: {
                block3: {
                    if (SummonerEntity.this.func_70638_az() instanceof WitherEntity) break block3;
                    for (int i = 0; i < 3; ++i) {
                        BlockPos pos = !SummonerEntity.this.isDungeonSpawned() ? SummonerEntity.this.func_180425_c() : new BlockPos(SummonerEntity.this.homeX, SummonerEntity.this.homeY, SummonerEntity.this.homeZ);
                        BlockPos spawnPos = new BlockPos(pos.func_177958_n() + -6 + SummonerEntity.this.field_70146_Z.nextInt(12), pos.func_177956_o(), pos.func_177952_p() + -6 + SummonerEntity.this.field_70146_Z.nextInt(12));
                        ArtificialGolemEntity golem = new ArtificialGolemEntity(SummonerEntity.this.field_70170_p, (LivingEntity)SummonerEntity.this);
                        golem.func_174828_a(spawnPos, 0.0f, 0.0f);
                        golem.func_213386_a((IWorld)SummonerEntity.this.field_70170_p, SummonerEntity.this.field_70170_p.func_175649_E(spawnPos), SpawnReason.MOB_SUMMONED, null, null);
                        if (SummonerEntity.this.func_70638_az() != null) {
                            golem.func_70624_b(SummonerEntity.this.func_70638_az());
                        }
                        golem.setPhaseTwo(SummonerEntity.this.secondPhaseHealth());
                        SummonerEntity.this.field_70170_p.func_217376_c((Entity)golem);
                    }
                    break block4;
                }
                if (!(SummonerEntity.this.func_70638_az() instanceof WitherEntity)) break block4;
                for (int i = 0; i < 3; ++i) {
                    BlockPos blockpos = new BlockPos((Entity)SummonerEntity.this).func_177982_a(-2 + SummonerEntity.this.field_70146_Z.nextInt(5), 1, -2 + SummonerEntity.this.field_70146_Z.nextInt(5));
                    NyctoflyEntity entitybug = new NyctoflyEntity(SkiesEntityTypes.NYCTOFLY, SummonerEntity.this.field_70170_p);
                    entitybug.func_174828_a(blockpos, 0.0f, 0.0f);
                    entitybug.func_213386_a((IWorld)SummonerEntity.this.field_70170_p, SummonerEntity.this.field_70170_p.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, null, null);
                    entitybug.func_70624_b(SummonerEntity.this.func_70638_az());
                    entitybug.func_195064_c(new EffectInstance(Effects.field_76420_g, 99999, 3));
                    entitybug.func_195064_c(new EffectInstance(Effects.field_76429_m, 99999, 2));
                    SummonerEntity.this.field_70170_p.func_217376_c((Entity)entitybug);
                }
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)SummonerEntity.this);
        }

        public void func_75246_d() {
            if (SummonerEntity.this.func_70638_az() != null) {
                SummonerEntity.this.func_70671_ap().func_75651_a((Entity)SummonerEntity.this.func_70638_az(), (float)SummonerEntity.this.func_184649_cE(), (float)SummonerEntity.this.func_70646_bf());
            }
        }
    }

    class SphereAttackGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private SphereAttackGoal() {
            super((SpellcastingIllagerEntity)SummonerEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return SummonerEntity.this.getInvulTime() <= 0;
        }

        protected int func_190869_f() {
            if (SummonerEntity.this.func_70638_az() != null && (double)SummonerEntity.this.func_70032_d((Entity)SummonerEntity.this.func_70638_az()) < 5.0) {
                return 40;
            }
            return 50;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            if (SummonerEntity.this.func_70638_az() != null && SummonerEntity.this.func_70638_az() instanceof LivingEntity) {
                LivingEntity target = SummonerEntity.this.func_70638_az();
                double d0 = Math.min(target.field_70163_u, SummonerEntity.this.field_70163_u);
                double d1 = Math.max(target.field_70163_u, SummonerEntity.this.field_70163_u) + 0.3;
                float f = (float)MathHelper.func_181159_b((double)(target.field_70161_v - SummonerEntity.this.field_70161_v), (double)(target.field_70165_t - SummonerEntity.this.field_70165_t));
                if ((double)SummonerEntity.this.func_70032_d((Entity)target) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.spawnLightning(SummonerEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, SummonerEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
                    }
                } else {
                    double x = SummonerEntity.this.func_70638_az().field_70165_t - SummonerEntity.this.field_70165_t;
                    double y = SummonerEntity.this.func_70638_az().func_174813_aQ().field_72338_b + (double)(SummonerEntity.this.func_70638_az().func_213302_cg() / 2.0f) - (SummonerEntity.this.field_70163_u + (double)(SummonerEntity.this.func_213302_cg() / 2.0f));
                    double z = SummonerEntity.this.func_70638_az().field_70161_v - SummonerEntity.this.field_70161_v;
                    this.spawnSphere(x, y, z);
                }
            }
        }

        private void spawnSphere(double posX, double posY, double posZ) {
            LivingEntity target = SummonerEntity.this.func_70638_az();
            if (target != null) {
                Vec3d lookVector = SummonerEntity.this.func_70676_i(1.0f);
                FluctuantSphereEntity projectile = new FluctuantSphereEntity(SummonerEntity.this.field_70170_p, (LivingEntity)SummonerEntity.this, posX, posY, posZ);
                projectile.field_70165_t = SummonerEntity.this.field_70165_t + lookVector.field_72450_a * 1.0;
                projectile.field_70163_u = SummonerEntity.this.field_70163_u + (double)(SummonerEntity.this.func_213302_cg() / 2.0f) + (double)0.2f;
                projectile.field_70161_v = SummonerEntity.this.field_70161_v + lookVector.field_72449_c * 1.0;
                projectile.field_70177_z = SummonerEntity.this.field_70759_as;
                SummonerEntity.this.field_70170_p.func_217376_c((Entity)projectile);
            }
        }

        private void spawnLightning(double posX, double posZ, double p_190876_5_, double posY, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!SummonerEntity.this.field_70170_p.func_175623_d(blockpos) || SummonerEntity.this.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!SummonerEntity.this.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = SummonerEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)SummonerEntity.this.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                StrangeLightningEntity bolt = new StrangeLightningEntity(SummonerEntity.this.field_70170_p);
                bolt.func_70012_b(posX, (double)blockpos.func_177956_o() + d0, posZ, 0.0f, 0.0f);
                SummonerEntity.this.field_70170_p.func_217376_c((Entity)bolt);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_ATTACK;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }
}

