/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.util.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BarrierBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemistEntity
extends SpellcastingIllagerEntity
implements ISkyBossMob {
    public static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(AlchemistEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_HOME = EntityDataManager.func_187226_a(AlchemistEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(AlchemistEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186742_b(true);
    private int teleportCooldown;
    private int timeSinceFighting;
    public double homeX;
    public double homeY;
    public double homeZ;

    public AlchemistEntity(EntityType<? extends AlchemistEntity> type, World worldIn) {
        super(SkiesEntityTypes.ALCHEMIST, worldIn);
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RegenGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new FireArrowGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new DecayingSpikeGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new PotionCloudGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new LiquidConversionGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new BlindlessGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_213644_t(reason == SpawnReason.SPAWN_EGG);
        if (reason == SpawnReason.TRIGGERED) {
            this.field_70170_p.func_175655_b(this.func_180425_c(), false);
            this.field_70170_p.func_175655_b(this.func_180425_c().func_177984_a(), false);
        }
        return spawnDataIn;
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_213315_a(MoverType type, Vec3d vec) {
        if (this.getInvulTime() <= 0) {
            super.func_213315_a(type, vec);
        } else {
            super.func_213315_a(type, new Vec3d(0.0, vec.field_72448_b, 0.0));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(HAS_HOME, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    public boolean hasHome() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_HOME);
    }

    public void setHasHome(boolean hasHome) {
        this.field_70180_af.func_187227_b(HAS_HOME, (Object)hasHome);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 1) {
            if (this.isDungeonSpawned() && this.hasHome()) {
                this.field_70170_p.func_180501_a(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ), SkiesBlocks.dawn_blinding_keystone.func_176223_P(), 2);
                this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ), SkiesBlocks.blinding_stone.func_176223_P());
                TileEntity keystone = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ));
                if (keystone instanceof KeystoneTileEntity) {
                    ((KeystoneTileEntity)keystone).setTeleportOffset(new BlockPos(0, -9, 5));
                    ((KeystoneTileEntity)keystone).setSpawnsBoss(false);
                    ((KeystoneTileEntity)keystone).setKeysRequired(false);
                }
            }
            DyeColor dyecolor = DyeColor.RED;
            ItemStack itemstack = this.makeFirework(dyecolor, 0);
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
            this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
        }
    }

    private ItemStack makeFirework(DyeColor color, int flightTime) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, 1);
        ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = itemstack1.func_190925_c("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(color.func_196060_f());
        compoundnbt.func_197646_b("Colors", (List)list);
        ArrayList fadelist = Lists.newArrayList();
        fadelist.add(DyeColor.YELLOW.func_196060_f());
        compoundnbt.func_197646_b("FadeColors", (List)fadelist);
        compoundnbt.func_74774_a("Type", (byte)FireworkRocketItem.Shape.LARGE_BALL.func_196071_a());
        CompoundNBT compoundnbt1 = itemstack.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        compoundnbt.func_74757_a("Flicker", true);
        CompoundNBT compoundnbt2 = itemstack1.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.func_74774_a("Flight", (byte)flightTime);
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return itemstack;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setDungeonSpawned(compound.func_74767_n("DungeonSpawned"));
        this.setHasHome(compound.func_74767_n("HasHome"));
        this.setInvulTime(compound.func_74762_e("Invul"));
        this.homeX = compound.func_74769_h("HomeX");
        this.homeY = compound.func_74769_h("HomeY");
        this.homeZ = compound.func_74769_h("HomeZ");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a("HomeX", this.homeX);
        compound.func_74780_a("HomeY", this.homeY);
        compound.func_74780_a("HomeZ", this.homeZ);
        compound.func_74768_a("Invul", this.getInvulTime());
        compound.func_74757_a("DungeonSpawned", this.isDungeonSpawned());
        compound.func_74757_a("HasHome", this.hasHome());
    }

    public void setHome(double posX, double posY, double posZ) {
        this.homeX = posX;
        this.homeY = posY;
        this.homeZ = posZ;
    }

    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a() == Effects.field_76436_u ? false : (effect.func_188419_a() == Effects.field_76433_i ? false : (effect.func_188419_a() == Effects.field_82731_v ? false : super.func_70687_e(effect)));
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.func_70638_az() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.field_70146_Z.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.func_110143_aJ() <= 250.0f) {
            double dx = this.field_70146_Z.nextGaussian() * 0.02;
            double dy = this.field_70146_Z.nextGaussian() * 0.02;
            double dz = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)SkiesParticles.BLACK_FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
        } else {
            this.spawnParticles((IParticleData)ParticleTypes.field_197624_q);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() > 0.7) {
            this.healthParticles();
        }
        if (!this.field_70170_p.field_72995_K) {
            List list;
            if (!this.func_193082_dl() && this.func_70090_H() || !this.func_193082_dl() && this.func_180799_ab()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.func_175446_cd()) {
                PlayerEntity player;
                if (this.hasHome()) {
                    this.checkIfHome();
                }
                if (this.func_70638_az() instanceof PlayerEntity && !(player = (PlayerEntity)this.func_70638_az()).func_70089_S()) {
                    this.func_70634_a(this.homeX, this.homeY, this.homeZ);
                }
                ++this.teleportCooldown;
            }
            if (this.func_110143_aJ() != 500.0f && this.timeSinceFighting >= 30 && this.isDungeonSpawned() && (list = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 1.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                this.func_70606_j(500.0f);
            }
            if (this.func_70638_az() != null) {
                if ((this.func_70638_az() instanceof PlayerEntity && this.func_70638_az().func_110143_aJ() == 0.0f || this.func_70638_az() instanceof PlayerEntity && !this.func_70638_az().func_70089_S() && this.isDungeonSpawned()) && !(list = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 5.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                    this.func_70691_i(30.0f);
                }
                this.timeSinceFighting = 0;
            }
            if (this.field_70737_aN > 0) {
                this.timeSinceFighting = 0;
            }
            if (this.func_70638_az() == null && this.timeSinceFighting <= 201) {
                ++this.timeSinceFighting;
            }
        }
    }

    public void func_70636_d() {
        int playerCount;
        super.func_70636_d();
        if (this.func_70638_az() != null && ((playerCount = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(4.0)).size()) > 0 && this.func_70638_az() instanceof PlayerEntity || (double)this.func_70032_d((Entity)this.func_70638_az()) <= 5.0) && !this.func_193082_dl()) {
            this.teleportAround();
        }
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 2.0f, 1.0f);
            }
            double d0 = 0.05;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.5, 0.0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, -d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, d0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197624_q, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, -d0);
            }
        }
    }

    public void checkIfHome() {
        int distance = 15;
        if (this.field_70165_t > this.homeX + (double)distance || this.field_70161_v > this.homeZ + (double)distance || this.field_70163_u > this.homeY + 10.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), SkiesBlocks.lunar_stonebrick.func_176223_P());
        } else if (this.field_70165_t < this.homeX - (double)distance || this.field_70161_v < this.homeZ - (double)distance || this.field_70163_u < this.homeY - 5.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), SkiesBlocks.lunar_stonebrick.func_176223_P());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource && !this.func_193082_dl()) {
            this.teleportAround();
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource && source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            ItemStack stack = player.field_71071_by.func_70448_g();
            boolean isMudkip = stack.func_77973_b().getRegistryName().toString().contains("mudkip");
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (isMudkip) {
                return false;
            }
            if (!source.func_180136_u() && !source.func_76352_a() && (double)source.func_76346_g().func_70032_d((Entity)this) > 3.5) {
                return false;
            }
            return super.func_70097_a(source, Math.min(21.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void teleportAround() {
        if (this.getInvulTime() <= 0) {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            for (int i = 0; i < 16; ++i) {
                double d3 = this.field_70165_t + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                double d4 = MathHelper.func_151237_a((double)(this.field_70163_u + (double)(this.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(this.field_70170_p.func_72940_L() - 1));
                double d5 = this.field_70161_v + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                if (this.func_184187_bx() != null) {
                    this.func_184210_p();
                }
                if (this.isDungeonSpawned()) {
                    if (!this.attemptDungeonTeleport(d3, d4, d5)) continue;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                    this.func_70656_aK();
                    break;
                }
                if (!this.func_213373_a(d3, d4, d5, true)) continue;
                this.field_70170_p.func_184148_a((PlayerEntity)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                this.func_70656_aK();
                break;
            }
        }
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && (double)blockpos.func_177956_o() > this.homeY - 3.0 && (double)blockpos.func_177956_o() <= this.homeY + 1.0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate == SkiesBlocks.lunar_stonebrick.func_176223_P() || iblockstate == SkiesBlocks.mossy_lunar_stonebrick.func_176223_P() || iblockstate == SkiesBlocks.cracked_lunar_stonebrick.func_176223_P()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_217345_j((Entity)this)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.func_213302_cg();
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d3, d4, d5, (double)f, (double)f1, (double)f2);
        }
        if (this instanceof CreatureEntity) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        ArrowEntity entityarrow = this.createArrowEntity(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)entityarrow);
        ArrowEntity arrow2 = this.createArrowEntity(distanceFactor);
        double e0 = target.field_70165_t - this.field_70165_t;
        double e1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow2.field_70163_u;
        double e2 = target.field_70161_v - this.field_70161_v;
        double e3 = MathHelper.func_76133_a((double)(e0 * e0 + e2 * e2));
        arrow2.func_70186_c(e0, e1 + e3 * (double)0.2f, e2 + 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow2);
        ArrowEntity arrow3 = this.createArrowEntity(distanceFactor);
        double z0 = target.field_70165_t - this.field_70165_t;
        double z1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow3.field_70163_u;
        double z2 = target.field_70161_v - this.field_70161_v;
        double z3 = MathHelper.func_76133_a((double)(z0 * z0 + z2 * z2));
        arrow3.func_70186_c(z0, z1 + z3 * (double)0.2f, z2 - 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow3);
        if (this.func_110143_aJ() <= 250.0f) {
            ArrowEntity arrow4 = this.createArrowEntity(distanceFactor);
            double y0 = target.field_70165_t - this.field_70165_t;
            double y1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow4.field_70163_u - 1.0;
            double y2 = target.field_70161_v - this.field_70161_v;
            double y3 = MathHelper.func_76133_a((double)(y0 * y0 + y2 * y2));
            arrow4.func_70186_c(y0, y1 + y3 * (double)0.2f, y2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow4.func_70015_d(7);
            this.field_70170_p.func_217376_c((Entity)arrow4);
            ArrowEntity arrow5 = this.createArrowEntity(distanceFactor);
            double t0 = target.field_70165_t - this.field_70165_t;
            double t1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow5.field_70163_u - 1.0;
            double t2 = target.field_70161_v - this.field_70161_v;
            double t3 = MathHelper.func_76133_a((double)(t0 * t0 + t2 * t2));
            arrow5.func_70186_c(t0, t1 + t3 * (double)0.2f, t2 + 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow5.func_70015_d(7);
            this.field_70170_p.func_217376_c((Entity)arrow5);
            ArrowEntity arrow6 = this.createArrowEntity(distanceFactor);
            double u0 = target.field_70165_t - this.field_70165_t;
            double u1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow6.field_70163_u - 1.0;
            double u2 = target.field_70161_v - this.field_70161_v;
            double u3 = MathHelper.func_76133_a((double)(u0 * u0 + u2 * u2));
            arrow6.func_70186_c(u0, u1 + u3 * (double)0.2f, u2 - 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow6.func_70015_d(7);
            this.field_70170_p.func_217376_c((Entity)arrow6);
        }
    }

    protected ArrowEntity createArrowEntity(float p_193097_1_) {
        ArrowEntity entitytippedarrow = new ArrowEntity(this.field_70170_p, (LivingEntity)this);
        entitytippedarrow.func_190547_a((LivingEntity)this, p_193097_1_);
        entitytippedarrow.func_70239_b(3.0);
        if (this.func_110143_aJ() <= 250.0f) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                entitytippedarrow.func_184558_a(new EffectInstance(Effects.field_76421_d, 300));
            }
            entitytippedarrow.func_70239_b(5.0);
        } else {
            entitytippedarrow.func_70239_b(3.0);
        }
        entitytippedarrow.func_70240_a(1);
        return entitytippedarrow;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_ALCHEMIST_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ALCHEMIST_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SkiesSounds.ENTITY_ALCHEMIST_HURT;
    }

    protected float func_70599_aP() {
        return 1.4f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles(IParticleData particleType) {
        double dx = this.field_70146_Z.nextGaussian() * 0.02;
        double dy = this.field_70146_Z.nextGaussian() * 0.02;
        double dz = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_195594_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_ALCHEMIST_CAST_SPELL;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return AlchemistEntity.this.getInvulTime() > 0;
        }
    }

    class FireArrowGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private FireArrowGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 200;
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        protected void func_190868_j() {
            LivingEntity entitylivingbase = AlchemistEntity.this.func_70638_az();
            if (entitylivingbase != null) {
                AlchemistEntity.this.attackEntityWithRangedAttack(entitylivingbase, BowItem.func_185059_b((int)40));
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ATTACK;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }

    class PotionCloudGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private PotionCloudGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        protected int func_190869_f() {
            return 70;
        }

        protected int func_190872_i() {
            return 300;
        }

        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            AlchemistEntity.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = AlchemistEntity.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundevent = this.func_190871_k();
            if (soundevent != null) {
                AlchemistEntity.this.func_184185_a(soundevent, 1.3f, 1.0f);
            }
            MathHelper.func_181159_b((double)(AlchemistEntity.this.func_70638_az().field_70161_v - AlchemistEntity.this.field_70161_v), (double)(AlchemistEntity.this.func_70638_az().field_70165_t - AlchemistEntity.this.field_70165_t));
            AlchemistEntity.this.func_193081_a(this.func_193320_l());
        }

        protected void func_190868_j() {
            LivingEntity entitylivingbase = AlchemistEntity.this.func_70638_az();
            if (entitylivingbase != null) {
                double d0 = Math.min(entitylivingbase.field_70163_u, AlchemistEntity.this.field_70163_u);
                double d1 = Math.max(entitylivingbase.field_70163_u, AlchemistEntity.this.field_70163_u) + 1.0;
                float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - AlchemistEntity.this.field_70161_v), (double)(entitylivingbase.field_70165_t - AlchemistEntity.this.field_70165_t));
                float f2 = f + 0.7853982f + 1.2566371f;
                this.spawnCloud(AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
                if (this.func_190872_i() < 2) {
                    AlchemistEntity.this.teleportAround();
                }
            }
        }

        private void spawnCloud(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos pos = !AlchemistEntity.this.isDungeonSpawned() ? AlchemistEntity.this.func_180425_c() : new BlockPos(AlchemistEntity.this.homeX, AlchemistEntity.this.homeY, AlchemistEntity.this.homeZ);
            AreaEffectCloudEntity potionCloudPX = new AreaEffectCloudEntity(AlchemistEntity.this.field_70170_p, (double)(pos.func_177958_n() + 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 5));
            AreaEffectCloudEntity potionCloudPZ = new AreaEffectCloudEntity(AlchemistEntity.this.field_70170_p, (double)(pos.func_177958_n() + 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 5));
            AreaEffectCloudEntity potionCloudNX = new AreaEffectCloudEntity(AlchemistEntity.this.field_70170_p, (double)(pos.func_177958_n() - 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 5));
            AreaEffectCloudEntity potionCloudNZ = new AreaEffectCloudEntity(AlchemistEntity.this.field_70170_p, (double)(pos.func_177958_n() - 5), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 5));
            Potion potiontype = AlchemistEntity.this.func_110143_aJ() <= 250.0f ? Potions.field_185252_x : Potions.field_185254_z;
            potionCloudPX.func_184484_a(potiontype);
            potionCloudPX.func_184486_b(200);
            potionCloudPX.func_184481_a((LivingEntity)AlchemistEntity.this);
            potionCloudPZ.func_184484_a(potiontype);
            potionCloudPZ.func_184486_b(200);
            potionCloudPZ.func_184481_a((LivingEntity)AlchemistEntity.this);
            potionCloudNX.func_184484_a(potiontype);
            potionCloudNX.func_184486_b(200);
            potionCloudNX.func_184481_a((LivingEntity)AlchemistEntity.this);
            potionCloudNZ.func_184484_a(potiontype);
            potionCloudNZ.func_184486_b(200);
            potionCloudNZ.func_184481_a((LivingEntity)AlchemistEntity.this);
            AlchemistEntity.this.field_70170_p.func_217376_c((Entity)potionCloudPX);
            AlchemistEntity.this.field_70170_p.func_217376_c((Entity)potionCloudPZ);
            AlchemistEntity.this.field_70170_p.func_217376_c((Entity)potionCloudNX);
            AlchemistEntity.this.field_70170_p.func_217376_c((Entity)potionCloudNZ);
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_POTIONS;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            if (AlchemistEntity.this.func_110143_aJ() <= 250.0f) {
                return SpellcastingIllagerEntity.SpellType.FANGS;
            }
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class DecayingSpikeGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private DecayingSpikeGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 270;
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            AlchemistEntity.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = AlchemistEntity.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundevent = this.func_190871_k();
            if (soundevent != null) {
                AlchemistEntity.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            float f = (float)MathHelper.func_181159_b((double)(AlchemistEntity.this.func_70638_az().field_70161_v - AlchemistEntity.this.field_70161_v), (double)(AlchemistEntity.this.func_70638_az().field_70165_t - AlchemistEntity.this.field_70165_t));
            if ((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    if (!(AlchemistEntity.this.field_70170_p instanceof ServerWorld)) continue;
                    ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, AlchemistEntity.this.field_70163_u + 5.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    if (!(AlchemistEntity.this.field_70170_p instanceof ServerWorld)) continue;
                    ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, AlchemistEntity.this.field_70163_u + 5.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                }
            }
            AlchemistEntity.this.func_193081_a(this.func_193320_l());
        }

        protected void func_190868_j() {
            LivingEntity entitylivingbase = AlchemistEntity.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, AlchemistEntity.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, AlchemistEntity.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - AlchemistEntity.this.field_70161_v), (double)(entitylivingbase.field_70165_t - AlchemistEntity.this.field_70165_t));
            if ((double)AlchemistEntity.this.func_70032_d((Entity)entitylivingbase) < 5.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    if (AlchemistEntity.this.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, AlchemistEntity.this.field_70163_u + 5.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                    }
                    this.spawnSpikeCircle(AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.0, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    if (AlchemistEntity.this.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, AlchemistEntity.this.field_70163_u + 5.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                    }
                    this.spawnSpikeLine(AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void spawnSpikeLine(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!AlchemistEntity.this.field_70170_p.func_175623_d(blockpos) || AlchemistEntity.this.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!AlchemistEntity.this.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = AlchemistEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)AlchemistEntity.this.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos(p_190876_1_, (double)blockpos.func_177956_o() + d0 + 5.0, p_190876_3_);
                DecayingSpikeEntity block = new DecayingSpikeEntity(AlchemistEntity.this.field_70170_p, blockpos2, SkiesBlocks.decaying_spike.func_176223_P(), (LivingEntity)AlchemistEntity.this);
                block.setDownwards(true);
                block.field_145812_b = 200;
                block.field_145813_c = false;
                AlchemistEntity.this.field_70170_p.func_217376_c((Entity)block);
            }
        }

        private void spawnSpikeCircle(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!AlchemistEntity.this.field_70170_p.func_175623_d(blockpos) || AlchemistEntity.this.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!AlchemistEntity.this.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = AlchemistEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)AlchemistEntity.this.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos((double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + d0);
                DecayingSpikeEntity block = new DecayingSpikeEntity(AlchemistEntity.this.field_70170_p, blockpos2, (BlockState)SkiesBlocks.decaying_spike.func_176223_P().func_206870_a((IProperty)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)), (LivingEntity)AlchemistEntity.this);
                block.setDownwards(false);
                block.func_70107_b((double)blockpos2.func_177958_n() + 0.5, blockpos2.func_177956_o(), (double)blockpos2.func_177952_p() + 0.5);
                block.field_145812_b = 200;
                block.func_213293_j(0.0, 0.7, 0.0);
                block.field_145813_c = false;
                AlchemistEntity.this.field_70170_p.func_217376_c((Entity)block);
            }
        }

        public void func_75246_d() {
            block4: {
                super.func_75246_d();
                LivingEntity entitylivingbase = AlchemistEntity.this.func_70638_az();
                if (entitylivingbase == null || AlchemistEntity.this.field_70173_aa % 5 != 0) break block4;
                float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - AlchemistEntity.this.field_70161_v), (double)(entitylivingbase.field_70165_t - AlchemistEntity.this.field_70165_t));
                if ((double)AlchemistEntity.this.func_70032_d((Entity)entitylivingbase) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        if (!(AlchemistEntity.this.field_70170_p instanceof ServerWorld)) continue;
                        ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.0, AlchemistEntity.this.field_70163_u + 0.2, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.0, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                    }
                } else {
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 1);
                        if (!(AlchemistEntity.this.field_70170_p instanceof ServerWorld)) continue;
                        ((ServerWorld)AlchemistEntity.this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.decaying_spike.func_176223_P()), AlchemistEntity.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, AlchemistEntity.this.field_70163_u + 5.0, AlchemistEntity.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, 20, (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), (double)(AlchemistEntity.this.func_213302_cg() / 4.0f), (double)(AlchemistEntity.this.func_213311_cf() / 4.0f), 0.05);
                    }
                }
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ROCKS;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }

    public class BlindlessGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        public BlindlessGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            if (AlchemistEntity.this.func_70638_az() != null && AlchemistEntity.this.func_70638_az() instanceof LivingEntity) {
                AlchemistEntity.this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_BLINDNESS;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.BLINDNESS;
        }
    }

    public class LiquidConversionGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        public boolean waterParticle;

        public LiquidConversionGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        public boolean func_75250_a() {
            if (AlchemistEntity.this.func_110143_aJ() > 250.0f) {
                return false;
            }
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int var7;
            int var6;
            int var5;
            int var4;
            int var1 = MathHelper.func_76128_c((double)AlchemistEntity.this.homeX);
            int var2 = MathHelper.func_76128_c((double)AlchemistEntity.this.homeZ);
            int radius = 25;
            boolean isWater = AlchemistEntity.this.field_70146_Z.nextBoolean();
            for (var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
                for (var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                    for (var6 = 0; var6 < 8; ++var6) {
                        var7 = (int)AlchemistEntity.this.homeY - 1 + var6;
                        if (!(AlchemistEntity.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177230_c() instanceof FlowingFluidBlock)) continue;
                        if ((Integer)AlchemistEntity.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
                            AlchemistEntity.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), Blocks.field_180401_cv.func_176223_P());
                            continue;
                        }
                        AlchemistEntity.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            for (var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
                for (var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                    for (var6 = 0; var6 < 8; ++var6) {
                        var7 = (int)AlchemistEntity.this.homeY - 1 + var6;
                        if (!(AlchemistEntity.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177230_c() instanceof BarrierBlock)) continue;
                        BlockState liquid = isWater ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150353_l.func_176223_P();
                        SoundEvent sound = isWater ? SoundEvents.field_187624_K : SoundEvents.field_187627_L;
                        AlchemistEntity.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), (BlockState)liquid.func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(0)));
                        AlchemistEntity.this.field_70170_p.func_184134_a(AlchemistEntity.this.field_70165_t, AlchemistEntity.this.field_70163_u, AlchemistEntity.this.field_70161_v, sound, SoundCategory.BLOCKS, 2.0f, AlchemistEntity.this.field_70146_Z.nextFloat() - AlchemistEntity.this.field_70146_Z.nextFloat() * 0.2f + 1.2f, false);
                    }
                }
            }
        }

        protected int func_190867_m() {
            return 30;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 90;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_CONVERSION;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    public class RegenGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        public RegenGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (AlchemistEntity.this.func_110143_aJ() > 250.0f) {
                return false;
            }
            if (AlchemistEntity.this.getInvulTime() > 0) {
                return false;
            }
            return AlchemistEntity.this.func_70638_az() == null || !((double)AlchemistEntity.this.func_70032_d((Entity)AlchemistEntity.this.func_70638_az()) < 5.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int playerCount = AlchemistEntity.this.field_70170_p.func_217357_a(PlayerEntity.class, AlchemistEntity.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (playerCount < 2) {
                AlchemistEntity.this.func_195064_c(new EffectInstance(Effects.field_76428_l, 20, 5, false, false));
            } else {
                AlchemistEntity.this.func_195064_c(new EffectInstance(Effects.field_76428_l, 30, 5, false, false));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 200;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_REGEN;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)AlchemistEntity.this);
        }

        public void func_75246_d() {
            if (AlchemistEntity.this.func_70638_az() != null) {
                AlchemistEntity.this.func_70671_ap().func_75651_a((Entity)AlchemistEntity.this.func_70638_az(), (float)AlchemistEntity.this.func_184649_cE(), (float)AlchemistEntity.this.func_70646_bf());
            }
        }
    }
}

