/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class VenomSpiderEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(VenomSpiderEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public VenomSpiderEntity(EntityType<? extends VenomSpiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AISpiderTarget<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, new AISpiderTarget<IronGolemEntity>(this, IronGolemEntity.class));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    public double func_70042_X() {
        return this.func_213302_cg() * 0.5f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_VENOM_SPIDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void setInWeb() {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() == Effects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Effect effect;
        if ((spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag)) == null) {
            spawnDataIn = new SpiderEntity.GroupData();
            if (worldIn.func_175659_aa() == Difficulty.HARD && worldIn.func_201674_k().nextFloat() < 0.1f * difficultyIn.func_180170_c()) {
                ((SpiderEntity.GroupData)spawnDataIn).func_111104_a(worldIn.func_201674_k());
            }
        }
        if (spawnDataIn instanceof SpiderEntity.GroupData && (effect = ((SpiderEntity.GroupData)spawnDataIn).field_188478_a) != null) {
            this.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE));
        }
        return spawnDataIn;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.spit(target);
    }

    private void spit(LivingEntity target) {
        VenomSpitEntity venom = new VenomSpitEntity(this.field_70170_p, this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - venom.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        venom.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 5.0f);
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SkiesSounds.ENTITY_VENOM_SPIDER_SPIT, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c((Entity)venom);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int durration = 20 * (this.field_70170_p.func_175659_aa().func_151525_a() + 3);
                int amplifier = this.field_70170_p.func_175659_aa().func_151525_a() / 2;
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
            }
            return true;
        }
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.65f;
    }

    static class SpiderAIAttackRanged
    extends Goal {
        private final CreatureEntity entityHost;
        private final IRangedAttackMob rangedAttackEntityHost;
        private LivingEntity attackTarget;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private int seeTime;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public SpiderAIAttackRanged(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public SpiderAIAttackRanged(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            if (!(attacker instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (CreatureEntity)attacker;
            this.entityMoveSpeed = movespeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        }

        public boolean func_75250_a() {
            LivingEntity entitylivingbase = this.entityHost.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (this.entityHost.func_70638_az().func_70032_d((Entity)this.entityHost) <= 5.0f) {
                return false;
            }
            this.attackTarget = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            if (this.entityHost.func_70638_az() != null && this.entityHost.func_70638_az().func_70032_d((Entity)this.entityHost) <= 5.0f) {
                return false;
            }
            if (this.entityHost.func_70661_as().func_75500_f()) {
                return false;
            }
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.attackTarget = null;
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        }

        public void updateTask() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entityHost.func_70661_as().func_75499_g();
            } else {
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }

    public static class GroupData
    implements ILivingEntityData {
        public Effect effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.effect = Effects.field_76424_c;
            } else if (i <= 2) {
                this.effect = Effects.field_76420_g;
            } else if (i <= 3) {
                this.effect = Effects.field_76428_l;
            } else if (i <= 4) {
                this.effect = Effects.field_76441_p;
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(SpiderEntity spider) {
            super((CreatureEntity)spider, 1.0, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75441_b.func_184207_aI();
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    static class AISpiderTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AISpiderTarget(VenomSpiderEntity spider, Class<T> classTarget) {
            super((MobEntity)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }
    }

    static class AISpiderAttack
    extends MeleeAttackGoal {
        public AISpiderAttack(VenomSpiderEntity spider) {
            super((CreatureEntity)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            LivingEntity entitylivingbase = this.field_75441_b.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (entitylivingbase.func_70032_d((Entity)this.field_75441_b) >= 5.0f) {
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.field_75441_b.func_70638_az() != null && this.field_75441_b.func_70638_az().func_70032_d((Entity)this.field_75441_b) >= 5.0f) {
                this.func_75251_c();
            } else {
                super.func_75246_d();
            }
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

