/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.ai.NonCreatureAttackGoal;
import com.legacy.blue_skies.entities.util.NyctoFlightSound;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NyctoflyEntity
extends FlyingEntity
implements IMob {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int field_70708_bq;
    @OnlyIn(value=Dist.CLIENT)
    private ISound flapSound;

    public NyctoflyEntity(EntityType<? extends NyctoflyEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
        this.func_189654_d(true);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (Goal)new NonCreatureAttackGoal((MobEntity)this, 1.7f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AILookAround(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
        if (this.func_175446_cd()) {
            super.func_213315_a(typeIn, Vec3d.field_186680_a);
        } else {
            super.func_213315_a(typeIn, pos);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateWingRotation();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            LivingEntity entitylivingbase = this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            this.field_70714_bg.func_85156_a((Goal)new AIRandomFly(this));
            this.func_70619_bc();
        } else if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
            this.field_70714_bg.func_75776_a(5, (Goal)new AIRandomFly(this));
            this.func_70619_bc();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70708_bq = this.func_213322_ci().field_72450_a <= 1.0 && this.func_213322_ci().field_72449_c <= 1.0 && this.field_70708_bq <= 100 ? ++this.field_70708_bq : 0;
        } else if (this.field_70122_E) {
            this.field_70122_E = false;
        }
        if (this.func_175446_cd()) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWingRotation() {
        if (!this.func_174814_R() && this.field_70170_p.field_72995_K) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.flapSound == null && !soundHandler.func_215294_c(this.flapSound)) {
                this.flapSound = new NyctoFlightSound(this);
                soundHandler.func_147682_a(this.flapSound);
            }
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = NyctoflyEntity.minMax(0.01f, 1.0f, this.destPos);
        this.wingRotation += 1.233f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.func_70097_a((DamageSource)new EntityDamageSource("bite", (Entity)this), 3.0f);
        this.func_184185_a(SkiesSounds.ENTITY_NYCTOBUG_BITE, 0.5f, 1.0f);
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_NYCTOBUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_NYCTOBUG_DEATH;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(NyctoflyEntity bug) {
            super((MobEntity)bug);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vec3d vec3d = new Vec3d(this.field_75646_b - NyctoflyEntity.this.field_70165_t, this.field_75647_c - NyctoflyEntity.this.field_70163_u, this.field_75644_d - NyctoflyEntity.this.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (d0 < NyctoflyEntity.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    NyctoflyEntity.this.func_213317_d(NyctoflyEntity.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    NyctoflyEntity.this.func_213317_d(NyctoflyEntity.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.func_75638_b() * 0.05 / d0)));
                    if (NyctoflyEntity.this.func_70638_az() == null) {
                        NyctoflyEntity.this.field_70761_aq = NyctoflyEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)NyctoflyEntity.this.func_213322_ci().field_72450_a, (double)NyctoflyEntity.this.func_213322_ci().field_72449_c)) * 57.295776f;
                        if (NyctoflyEntity.this.field_70124_G && NyctoflyEntity.this.field_70173_aa > 100) {
                            NyctoflyEntity.this.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72450_a, vec3d.field_72449_c, 1.0);
                        }
                        if (NyctoflyEntity.this.field_70708_bq >= 300 || !this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d0)) {
                            this.field_188491_h = MovementController.Action.WAIT;
                        }
                    } else {
                        double d4 = NyctoflyEntity.this.func_70638_az().field_70165_t - NyctoflyEntity.this.field_70165_t;
                        double d5 = NyctoflyEntity.this.func_70638_az().field_70161_v - NyctoflyEntity.this.field_70161_v;
                        NyctoflyEntity.this.field_70761_aq = NyctoflyEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }

        public double func_75638_b() {
            if (NyctoflyEntity.this.func_70638_az() != null && (double)NyctoflyEntity.this.func_70032_d((Entity)NyctoflyEntity.this.func_70638_az()) < 7.0) {
                return 0.6;
            }
            return 0.8;
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - NyctoflyEntity.this.field_70165_t) / p_179926_7_;
            double d1 = (y - NyctoflyEntity.this.field_70163_u) / p_179926_7_;
            double d2 = (z - NyctoflyEntity.this.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = NyctoflyEntity.this.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!NyctoflyEntity.this.field_70170_p.func_217351_c(axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends Goal {
        private final NyctoflyEntity parentEntity;

        public AIRandomFly(NyctoflyEntity bug) {
            this.parentEntity = bug;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a() && this.parentEntity.func_70638_az() == null) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class AILookAround
    extends Goal {
        private final NyctoflyEntity parentEntity;

        public AILookAround(NyctoflyEntity bug) {
            this.parentEntity = bug;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void updateTask() {
            if (this.parentEntity.func_70638_az() == null) {
                Vec3d vec3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity entitylivingbase = this.parentEntity.func_70638_az();
                if ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

