/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmoredFrostSpiritEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(ArmoredFrostSpiritEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(ArmoredFrostSpiritEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(ArmoredFrostSpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ArmoredFrostSpiritEntity(EntityType<? extends ArmoredFrostSpiritEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{ZombiePigmanEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.17);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    public void setIceType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public int getIceType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public boolean func_70097_a(DamageSource ds, float amount) {
        if (ds == DamageSource.field_76370_b || ds == DamageSource.field_76372_a || ds == DamageSource.field_76369_e) {
            if (!(ds != DamageSource.field_76370_b && ds != DamageSource.field_76372_a || this.func_174814_R())) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.HOSTILE, 0.3f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187917_gq, SoundCategory.HOSTILE, 0.8f, 1.0f);
            }
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218422_X, this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 20, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            }
            return super.func_70097_a(ds, amount * 2.0f);
        }
        if (ds.func_76346_g() instanceof LivingEntity && this.field_70737_aN == 0) {
            if (this.field_70170_p instanceof ServerWorld) {
                for (int i = 0; i < 2; ++i) {
                    if (this.getIceType() == 1) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150403_cj.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 20, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                        continue;
                    }
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150432_aD.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 20, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                }
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.HOSTILE, 0.5f, 1.0f);
            }
            if (ds.func_76364_f() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ds.func_76364_f();
                ItemStack stack = player.field_71071_by.func_70448_g();
                boolean isTCPickaxe = stack.func_77973_b().getClass().getName().equals("slimeknights.tconstruct.tools.tools.Pickaxe");
                boolean isOtherPick = stack.func_77973_b().getRegistryName().toString().contains("pickaxe");
                if (stack.func_77973_b() instanceof PickaxeItem || isTCPickaxe || isOtherPick) {
                    return super.func_70097_a(ds, amount + 4.0f);
                }
            }
        }
        return super.func_70097_a(ds, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return 120;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f;
    }

    public void determineTypeByDifficulty() {
        int chance = this.field_70146_Z.nextInt(4);
        if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
            if (chance == 0) {
                this.setIceType(1);
            } else {
                this.setIceType(0);
            }
        } else if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
            this.setIceType(this.field_70146_Z.nextInt(2));
        } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            if (chance == 0) {
                this.setIceType(0);
            } else {
                this.setIceType(1);
            }
        }
    }

    public static Item getSkyArmorByChance(EquipmentSlotType slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                if (chance == 0) {
                    return Items.field_151024_Q;
                }
                if (chance == 1) {
                    return SkiesItems.pyrope_helmet;
                }
                if (chance == 2) {
                    return SkiesItems.turquoise_helmet;
                }
                if (chance == 3) {
                    return SkiesItems.diopside_helmet;
                }
                if (chance == 4) {
                    return SkiesItems.charoite_helmet;
                }
            }
            case CHEST: {
                if (chance == 0) {
                    return Items.field_151027_R;
                }
                if (chance == 1) {
                    return SkiesItems.pyrope_chestplate;
                }
                if (chance == 2) {
                    return SkiesItems.turquoise_chestplate;
                }
                if (chance == 3) {
                    return SkiesItems.diopside_chestplate;
                }
                if (chance == 4) {
                    return SkiesItems.charoite_chestplate;
                }
            }
            case LEGS: {
                if (chance == 0) {
                    return Items.field_151026_S;
                }
                if (chance == 1) {
                    return SkiesItems.pyrope_leggings;
                }
                if (chance == 2) {
                    return SkiesItems.turquoise_leggings;
                }
                if (chance == 3) {
                    return SkiesItems.diopside_leggings;
                }
                if (chance == 4) {
                    return SkiesItems.charoite_leggings;
                }
            }
            case FEET: {
                if (chance == 0) {
                    return Items.field_151021_T;
                }
                if (chance == 1) {
                    return SkiesItems.pyrope_boots;
                }
                if (chance == 2) {
                    return SkiesItems.turquoise_boots;
                }
                if (chance == 3) {
                    return SkiesItems.diopside_boots;
                }
                if (chance != 4) break;
                return SkiesItems.charoite_boots;
            }
        }
        return null;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        if (this.field_70146_Z.nextFloat() < 0.15f * difficulty.func_180170_c()) {
            float f;
            i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlotType entityequipmentslot : EquipmentSlotType.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = ArmoredFrostSpiritEntity.getSkyArmorByChance(entityequipmentslot, i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack((IItemProvider)item));
            }
        }
        float f = this.field_70146_Z.nextFloat();
        float f3 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f3) {
            i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SkiesItems.turquoise_sword));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SkiesItems.pyrope_sword));
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74768_a("IceType", this.getIceType());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setIceType(compound.func_74762_e("IceType"));
    }

    public float func_213307_e(Pose pose) {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184187_bx() != null ? false : super.func_175448_a(stack);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.determineTypeByDifficulty();
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        if (this.getIceType() == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 8.0, AttributeModifier.Operation.ADDITION));
        }
        if (this.field_70170_p.func_72896_J()) {
            if (this.getIceType() == 1) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 3.0, AttributeModifier.Operation.ADDITION));
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("armor boost", 7.0, AttributeModifier.Operation.ADDITION));
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("speed boost", 0.04, AttributeModifier.Operation.ADDITION));
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("attack nerf", -1.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return spawnDataIn;
    }

    protected void func_70619_bc() {
        if (this.func_203005_aq() && this.field_70173_aa % 20 == 0) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos = new BlockPos((Entity)this).func_177963_a(0.0, 1.5, 0.0);
            FrostSpiritEntity spirit = (FrostSpiritEntity)SkiesEntityTypes.FROST_SPIRIT.func_200721_a(this.field_70170_p);
            spirit.func_174828_a(blockpos, this.field_70177_z, this.field_70125_A);
            spirit.func_213293_j(0.0, 1.0, 0.0);
            spirit.func_174810_b(this.func_174814_R());
            spirit.func_200203_b(this.func_200201_e());
            spirit.func_174805_g(this.func_174833_aM());
            this.field_70170_p.func_217376_c((Entity)spirit);
            this.func_70656_aK();
            this.func_70106_y();
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SkiesSounds.ENTITY_FROST_SPIRIT_FREE, SoundCategory.HOSTILE, this.func_70599_aP(), 1.0f);
            }
        }
    }

    public int func_70641_bl() {
        return 1;
    }
}

