/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.models.entities.SpiritModel;
import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class SpiritRenderer
extends MobRenderer<FrostSpiritEntity, SpiritModel<FrostSpiritEntity>> {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/entity/frost_spirit/frost_spirit_wings.png");

    public SpiritRenderer(EntityRendererManager renderManager) {
        super(renderManager, new SpiritModel(1.0f, 0.0f, 64, 32), 0.25f);
    }

    protected void translateSpirit(FrostSpiritEntity bug) {
        GlStateManager.translated((double)0.0, (double)1.5, (double)0.0);
    }

    protected float getWingRotation(FrostSpiritEntity bug, float f) {
        float f1 = bug.prevWingRotation + (bug.wingRotation - bug.prevWingRotation) * f;
        float f2 = bug.prevDestPos + (bug.destPos - bug.prevDestPos) * f;
        return (MathHelper.func_76126_a((float)f1) + 0.0f) * f2;
    }

    protected float handleRotationFloat(FrostSpiritEntity entityliving, float f) {
        return this.getWingRotation(entityliving, f);
    }

    protected void preRenderCallback(FrostSpiritEntity entityliving, float f) {
        this.translateSpirit(entityliving);
    }

    protected ResourceLocation getEntityTexture(FrostSpiritEntity entity) {
        return TEXTURE;
    }
}

