/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle.data;

import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class StarFlareData
implements IParticleData {
    public static final IParticleData.IDeserializer<StarFlareData> DESERIALIZER = new IParticleData.IDeserializer<StarFlareData>(){

        public StarFlareData deserialize(ParticleType<StarFlareData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = (float)reader.readDouble();
            reader.expect(' ');
            float g = (float)reader.readDouble();
            reader.expect(' ');
            float b = (float)reader.readDouble();
            return new StarFlareData(r, g, b);
        }

        public StarFlareData read(ParticleType<StarFlareData> particleTypeIn, PacketBuffer buffer) {
            return new StarFlareData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;

    public StarFlareData(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ParticleType<StarFlareData> func_197554_b() {
        return SkiesParticles.STAR_FLARE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBlue() {
        return this.blue;
    }
}

