/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client;

import com.legacy.blue_skies.items.util.IFalsiteCompat;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.world.everbright.BrightWeatherRenderer;
import com.legacy.blue_skies.world.everdawn.DawnWeatherRenderer;
import com.legacy.blue_skies.world.everdawn.EverdawnDimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    @SubscribeEvent
    public void onRenderToolTip(ItemTooltipEvent event) {
        if (event.getItemStack() != null && event.getItemStack().func_77973_b() instanceof IFalsiteCompat && ((IFalsiteCompat)event.getItemStack().func_77973_b()).isCompatible() && IFalsiteCompat.getFalsiteUses(event.getItemStack()) > 0) {
            event.getToolTip().add(1, new TranslationTextComponent("gui.item.falsite_uses", new Object[]{IFalsiteCompat.getFalsiteUses(event.getItemStack()), IFalsiteCompat.getMaxFalsiteUses(event.getItemStack())}).func_211708_a(TextFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null || !world.field_72995_K) {
            return;
        }
        IRenderHandler renderer = world.field_73011_w.getWeatherRenderer();
        if (renderer instanceof BrightWeatherRenderer) {
            ((BrightWeatherRenderer)renderer).onUpdate();
        } else if (renderer instanceof DawnWeatherRenderer) {
            ((DawnWeatherRenderer)renderer).onUpdate();
            EverdawnDimension dawn = (EverdawnDimension)world.field_73011_w;
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            BlockPos blockpos = new BlockPos(entity);
            Biome biome = world.func_180494_b(new BlockPos(blockpos.func_177958_n(), 0, blockpos.func_177952_p()));
            boolean bossOut = Minecraft.func_71410_x().field_71456_v.func_184046_j().func_184054_d();
            if (blockpos.func_177956_o() < world.func_181545_F() && world.func_175642_b(LightType.SKY, blockpos) <= 0 && dawn.sandstormStrength > 2.0f) {
                dawn.sandstormStrength -= 1.0f;
            } else if (bossOut && dawn.sandstormStrength > 10.0f && world.func_175642_b(LightType.SKY, blockpos) <= 5 && blockpos.func_177956_o() >= world.func_181545_F()) {
                dawn.sandstormStrength -= 1.0f;
            } else if (world.func_175642_b(LightType.SKY, blockpos) <= 12 && dawn.sandstormStrength > 30.0f) {
                dawn.sandstormStrength -= 1.0f;
            } else if (world.field_73004_o > 0.0f && biome == SkiesBiomes.CRYSTAL_DUNES && dawn.sandstormStrength < 200.0f) {
                dawn.sandstormStrength += 1.0f;
            } else if (dawn.sandstormStrength > 2.0f && biome != SkiesBiomes.CRYSTAL_DUNES && dawn.sandstormStrength <= 200.0f || world.field_73004_o < 1.0f && dawn.sandstormStrength > 2.0f) {
                dawn.sandstormStrength -= 1.0f;
            }
        }
    }
}

