/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class SkyFarmlandBlock
extends FarmlandBlock {
    public SkyFarmlandBlock(Block.Properties builder) {
        super(builder);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)(this == SkiesBlocks.lunar_farmland ? SkiesBlocks.lunar_dirt.func_176223_P() : SkiesBlocks.turquoise_dirt.func_176223_P()), (float)fallDistance, (Entity)entityIn)) {
            SkyFarmlandBlock.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        entityIn.func_180430_e(fallDistance, 1.0f);
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            SkyFarmlandBlock.turnToDirt(state, worldIn, pos);
        } else {
            int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
            if (!SkyFarmlandBlock.hasWater((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                    SkyFarmlandBlock.turnToDirt(state, worldIn, pos);
                }
            } else if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    private static boolean hasWater(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, SkyFarmlandBlock.func_199601_a((BlockState)state, (BlockState)(state.func_177230_c() == SkiesBlocks.lunar_farmland ? SkiesBlocks.lunar_dirt.func_176223_P() : SkiesBlocks.turquoise_dirt.func_176223_P()), (World)worldIn, (BlockPos)pos));
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            return (Integer)state.func_177229_b((IProperty)FarmlandBlock.field_176531_a) > 0;
        }
        return false;
    }
}

