/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BanefulMushroomBlock
extends BushBlock {
    private static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BanefulMushroomBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            worldIn.func_180501_a(pos, this.func_176223_P(), 3);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        this.applyPoison(worldIn, pos, entityIn);
    }

    public void applyPoison(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70687_e(new EffectInstance(Effects.field_76436_u))) {
            int durration = 20 * (worldIn.func_175659_aa().func_151525_a() + 3);
            int amplifier = worldIn.func_175659_aa().func_151525_a() / 2;
            worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)));
            if (!((LivingEntity)entityIn).func_70644_a(Effects.field_76436_u)) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
            }
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 100);
            if (worldIn.func_201670_d()) {
                this.func_180655_c(worldIn.func_180495_p(pos), worldIn, pos, new Random());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)OPEN)).booleanValue() && rand.nextFloat() < 0.7f) {
            Vec3d vec3d = stateIn.func_191059_e((IBlockReader)worldIn, pos);
            for (int i = 0; i < rand.nextInt(2) + 1; ++i) {
                float dx = (rand.nextFloat() - 0.5f) / 7.0f;
                float dy = rand.nextFloat() / 10.0f;
                float dz = (rand.nextFloat() - 0.5f) / 7.0f;
                worldIn.func_195594_a((IParticleData)new PoisonData(false), (double)pos.func_177958_n() + 0.5 + vec3d.field_72450_a, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + vec3d.field_72449_c, (double)dx, (double)dy, (double)dz);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{OPEN});
    }
}

