/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.dungeon;

import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.util.LogicUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StarFlareBlock
extends Block {
    private static final VoxelShape FLARE_SHAPE = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final IntegerProperty COLOR = IntegerProperty.func_177719_a((String)"color", (int)0, (int)15);

    public StarFlareBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_200947_a(SoundType.field_185854_g).func_200951_a(15).func_200942_a());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return FLARE_SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            this.func_180655_c(state, worldIn, pos, this.RANDOM);
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_175142_cm() && player.func_184586_b(handIn).func_77973_b() instanceof DyeItem) {
            ItemStack heldItem = player.func_184586_b(handIn);
            int appliedColor = ((DyeItem)heldItem.func_77973_b()).func_195962_g().func_196059_a();
            if (appliedColor != (Integer)state.func_177229_b((IProperty)COLOR)) {
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)COLOR, (Comparable)Integer.valueOf(appliedColor)));
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItem.func_77973_b()));
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K) {
            for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                double offset = 0.1;
                double x = LogicUtil.plusOrMinus((double)pos.func_177958_n() + 0.5, offset);
                double y = LogicUtil.plusOrMinus((double)pos.func_177956_o() + 0.5, offset);
                double z = LogicUtil.plusOrMinus((double)pos.func_177952_p() + 0.5, offset);
                double motion = 0.018;
                double dx = LogicUtil.plusOrMinus(motion);
                double dy = LogicUtil.plusOrMinus(motion);
                double dz = LogicUtil.plusOrMinus(motion);
                worldIn.func_195594_a((IParticleData)StarFlareParticle.dyeToRGB(DyeColor.values()[(Integer)stateIn.func_177229_b((IProperty)COLOR)]), x, y, z, dx, dy, dz);
            }
            worldIn.func_195594_a((IParticleData)StarFlareParticle.dyeToRGB(DyeColor.values()[(Integer)stateIn.func_177229_b((IProperty)COLOR)]), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{COLOR});
    }
}

