/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.dungeon;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class KeystoneBlock
extends ContainerBlock {
    public KeystoneBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150357_h));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_175142_cm()) {
            if (worldIn.func_175625_s(pos) instanceof KeystoneTileEntity) {
                KeystoneTileEntity tile = (KeystoneTileEntity)worldIn.func_175625_s(pos);
                ItemStack heldItem = player.func_184586_b(handIn);
                if (player.func_184812_l_() && heldItem.func_77973_b() instanceof SpawnEggItem) {
                    EntityType entityType = ((SpawnEggItem)heldItem.func_77973_b()).func_208076_b(heldItem.func_77978_p());
                    tile.setContainedMob(entityType);
                    return true;
                }
                if (tile.getSpawnsBoss() && (tile.isCorrectKey(heldItem) || tile.isCorrectArc(heldItem.func_77973_b()))) {
                    tile.spawnMob();
                    tile.teleportClosePlayers(worldIn);
                    tile.setKeysRequired(false);
                    if (tile.isCorrectKey(heldItem)) {
                        if (!player.func_184812_l_()) {
                            heldItem.func_190918_g(4);
                        }
                        if (worldIn.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.remove_key_requirement", new Object[0]), true);
                        }
                        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItem.func_77973_b()));
                    } else if (tile.isCorrectArc(heldItem.func_77973_b())) {
                        if (!player.func_184812_l_()) {
                            player.func_184811_cZ().func_185145_a(heldItem.func_77973_b(), 12000);
                        }
                        if (worldIn.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.arc_drained", new Object[]{heldItem.func_77973_b().func_200296_o().func_150261_e()}), true);
                        }
                        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItem.func_77973_b()));
                    }
                    if (worldIn.field_72995_K) {
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SkiesSounds.BLOCK_KEYSTONE_UNLOCK, SoundCategory.BLOCKS, 1.0f, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.0f, false);
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                    }
                    return true;
                }
                if (!tile.getSpawnsBoss() || !tile.getKeysRequired()) {
                    tile.teleportPlayer(player);
                    if (worldIn.field_72995_K) {
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                    }
                    return true;
                }
                if (tile.getKeysRequired()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.requires_keys", new Object[0]), true);
                    if (worldIn.field_72995_K) {
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundCategory.BLOCKS, 1.0f, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.0f, false);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.func_220051_a(state, worldIn, pos, player, handIn, hit);
    }

    public static class BlindingKeystoneBlock
    extends KeystoneBlock {
        private static final VoxelShape shape = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.func_208617_a((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.func_208617_a((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0)});

        public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return shape;
        }

        public TileEntity func_196283_a_(IBlockReader worldIn) {
            return this == SkiesBlocks.bright_blinding_keystone ? new KeystoneTileEntity.BrightBlindingKeystoneTileEntity() : new KeystoneTileEntity.DawnBlindingKeystoneTileEntity();
        }
    }
}

