/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks;

import com.google.common.cache.LoadingCache;
import com.legacy.blue_skies.entities.util.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.LogicUtil;
import com.legacy.blue_skies.util.ObfuscationShortcuts;
import com.legacy.blue_skies.world.teleporter.SkyTeleporter;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SkyPortalBlock
extends NetherPortalBlock {
    private static final Field defaultTeleporter = ObfuscationReflectionHelper.findField(ServerWorld.class, (String)"field_85177_Q");
    private Supplier<? extends Block> frame;
    private Supplier<? extends DimensionType> dimType;

    public SkyPortalBlock(Supplier<? extends Block> frame, Supplier<? extends DimensionType> dimType) {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11).func_222380_e());
        this.frame = frame;
        this.dimType = dimType;
    }

    public Block getFrameBlock() {
        return this.frame.get();
    }

    public DimensionType getDimType() {
        return this.dimType.get();
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(170) == 0) {
            if (this == SkiesBlocks.everdawn_portal) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERDAWN_PORTAL, SoundCategory.BLOCKS, 0.3f, 1.0f, false);
            } else {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SkiesSounds.BLOCK_EVERBRIGHT_PORTAL, SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.4f + 0.8f, false);
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = LogicUtil.plusOrMinus((double)pos.func_177958_n() + 0.5, 0.45);
            double y = LogicUtil.plusOrMinus((double)pos.func_177956_o() + 0.5, 0.45);
            double z = LogicUtil.plusOrMinus((double)pos.func_177952_p() + 0.5, 0.45);
            double dx = LogicUtil.plusOrMinus(0.06);
            double dy = this == SkiesBlocks.everbright_portal ? -1.0E-4 : 1.0E-4;
            double dz = LogicUtil.plusOrMinus(0.001);
            if (stateIn.func_177229_b((IProperty)field_176550_a) == Direction.Axis.X) {
                dx = LogicUtil.plusOrMinus(0.001);
                dz = LogicUtil.plusOrMinus(0.06);
                z = (double)pos.func_177952_p() + 0.5;
            } else {
                x = (double)pos.func_177958_n() + 0.5;
            }
            worldIn.func_195594_a((IParticleData)(this == SkiesBlocks.everbright_portal ? SkiesParticles.EVERBRIGHT_PORTAL : SkiesParticles.EVERDAWN_PORTAL), x, y, z, dx, dy, dz);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.func_201670_d() && this.canEntityTravel(entity)) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else {
                DimensionType destDim = world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ ? this.getDimType() : DimensionType.field_223227_a_;
                ServerWorld destWorld = world.func_73046_m().func_71218_a(destDim);
                Teleporter oldDefaultTp = destWorld.func_85176_s();
                ObfuscationShortcuts.setObfuscatedValue(defaultTeleporter, destWorld, (Object)new SkyTeleporter(world.func_73046_m().func_71218_a(destDim), this));
                SkyTeleporter.setLastPortalVec(pos, entity, this);
                entity.field_71088_bW = 500;
                entity.func_212321_a(destDim);
                ObfuscationShortcuts.setObfuscatedValue(defaultTeleporter, destWorld, oldDefaultTp);
            }
        }
    }

    private boolean canEntityTravel(Entity entity) {
        return !entity.func_184207_aI() && entity.func_184187_bx() == null && entity.func_184222_aU() && !(entity instanceof ISkyBossMob);
    }

    public boolean func_176548_d(IWorld worldIn, BlockPos pos) {
        Size sizeX = new Size(worldIn, pos, Direction.Axis.X, this.getFrameBlock(), (Block)this);
        if (sizeX.isValid() && sizeX.portalBlockCount == 0) {
            sizeX.placePortalBlocks();
            return true;
        }
        Size sizeZ = new Size(worldIn, pos, Direction.Axis.Z, this.getFrameBlock(), (Block)this);
        if (sizeZ.isValid() && sizeZ.portalBlockCount == 0) {
            sizeZ.placePortalBlocks();
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis facingAxis = facing.func_176740_k();
        Direction.Axis stateAxis = (Direction.Axis)stateIn.func_177229_b((IProperty)field_176550_a);
        boolean flag = stateAxis != facingAxis && facingAxis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, stateAxis, this.getFrameBlock(), (Block)this).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Size size;
        Direction.Axis enumfacing$axis = (Direction.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == Direction.Axis.X) {
            Size size2 = new Size((IWorld)worldIn, pos, Direction.Axis.X, this.getFrameBlock(), (Block)this);
            if (!size2.isValid() || size2.portalBlockCount < size2.width * size2.height) {
                worldIn.func_175655_b(pos, false);
            }
        } else if (!(enumfacing$axis != Direction.Axis.Z || (size = new Size((IWorld)worldIn, pos, Direction.Axis.Z, this.getFrameBlock(), (Block)this)).isValid() && size.portalBlockCount >= size.width * size.height)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public BlockPattern.PatternHelper func_181089_f(IWorld worldIn, BlockPos pos) {
        Direction.Axis directionAxis = Direction.Axis.Z;
        Size size = new Size(worldIn, pos, Direction.Axis.X, this.getFrameBlock(), (Block)this);
        LoadingCache loadingCache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!size.isValid()) {
            directionAxis = Direction.Axis.X;
            size = new Size(worldIn, pos, Direction.Axis.Z, this.getFrameBlock(), (Block)this);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, loadingCache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = size.rightDir.func_176735_f();
        BlockPos blockpos = size.bottomLeft.func_177981_b(size.getHeight() - 1);
        for (Direction.AxisDirection axisValue : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper patternHelper = new BlockPattern.PatternHelper(direction.func_176743_c() == axisValue ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisValue, (Direction.Axis)directionAxis), Direction.UP, loadingCache, size.getWidth(), size.getHeight(), 1);
            for (int i = 0; i < size.getWidth(); ++i) {
                for (int j = 0; j < size.getHeight(); ++j) {
                    CachedBlockInfo cachedBlockInfo = patternHelper.func_177670_a(i, j, 1);
                    if (cachedBlockInfo.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = axisValue.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection axisDirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection axisValue : Direction.AxisDirection.values()) {
            if (aint[axisValue.ordinal()] >= aint[axisDirection1.ordinal()]) continue;
            axisDirection1 = axisValue;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == axisDirection1 ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisDirection1, (Direction.Axis)directionAxis), Direction.UP, loadingCache, size.getWidth(), size.getHeight(), 1);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState frame_block = this == SkiesBlocks.everdawn_portal ? SkiesBlocks.lunar_stonebrick.func_176223_P() : SkiesBlocks.turquoise_stonebrick.func_176223_P();
        for (int y = -1; y <= 3; ++y) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (int x = -1; x <= 2; ++x) {
                    worldIn.func_180501_a(pos.func_177982_a(x, y, 0), frame_block, 18);
                }
                continue;
            }
            for (int z = -1; z <= 2; ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, y, z), frame_block, 18);
            }
        }
        for (int y1 = 0; y1 <= 2; ++y1) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (int x1 = 0; x1 <= 1; ++x1) {
                    worldIn.func_180501_a(pos.func_177982_a(x1, y1, 0), (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)Direction.Axis.X), 18);
                }
                continue;
            }
            for (int z1 = 0; z1 <= 1; ++z1) {
                worldIn.func_180501_a(pos.func_177982_a(0, y1, z1), (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)Direction.Axis.Z), 18);
            }
        }
    }

    public Size isSkyPortal(IWorld worldIn, BlockPos pos) {
        Size sizeX = new Size(worldIn, pos, Direction.Axis.X, this.getFrameBlock(), (Block)this);
        if (sizeX.isValid() && sizeX.portalBlockCount == 0) {
            return sizeX;
        }
        Size sizeZ = new Size(worldIn, pos, Direction.Axis.Z, this.getFrameBlock(), (Block)this);
        return sizeZ.isValid() && sizeZ.portalBlockCount == 0 ? sizeZ : null;
    }

    public static class Size {
        private final Block frame;
        private final Block portal;
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(IWorld world, BlockPos pos, Direction.Axis axis, Block frame, Block portal) {
            this.world = world;
            this.axis = axis;
            this.frame = frame;
            this.portal = portal;
            if (axis == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.func_196900_a(world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction direction) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.world.func_180495_p(blockpos = pos.func_177967_a(direction, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.frame; ++i) {
            }
            Block block = this.world.func_180495_p(pos.func_177967_a(direction, i)).func_177230_c();
            return block == this.frame ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.func_196900_a(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != this.frame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != this.frame) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean func_196900_a(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_185904_a() == Material.field_151579_a || block == Blocks.field_150480_ab || block == this.portal || block == Blocks.field_150350_a || block == SkiesBlocks.blue_fire || block == SkiesBlocks.black_fire;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)this.portal.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean func_208508_f() {
            return this.isValid() && this.func_196899_f();
        }
    }
}

