/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="blue_skies", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlueSkiesConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static boolean festivities;

    private static String translate(String key) {
        return new String("blue_skies.config." + key + ".name");
    }

    @SubscribeEvent
    public static void onLoadConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
            festivities = (Boolean)BlueSkiesConfig.CLIENT.festivities.get();
            System.out.println(BlueSkiesConfig.CLIENT.festivities.get());
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
        }
    }

    private static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> festivities;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            this.festivities = builder.translation(BlueSkiesConfig.translate("festivities")).comment(BlueSkiesConfig.translate("festivities.comment")).define("festivities", true);
            builder.pop();
        }
    }
}

