/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.blocks.util.Composting;
import com.legacy.blue_skies.blocks.util.Flammability;
import com.legacy.blue_skies.client.ClientEvents;
import com.legacy.blue_skies.client.SkyBlockColoring;
import com.legacy.blue_skies.client.SkyItemColoring;
import com.legacy.blue_skies.client.audio.SkiesMusicHandler;
import com.legacy.blue_skies.client.renders.SkiesEntityRendering;
import com.legacy.blue_skies.client.renders.SkiesTileEntityRendering;
import com.legacy.blue_skies.crafting.FuelHandler;
import com.legacy.blue_skies.events.SkiesEvents;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseConfig;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="blue_skies")
public class BlueSkies {
    public static final String NAME = "Blue Skies";
    public static final String VERSION = "0.0.1";
    public static final String MODID = "blue_skies";

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return new String("blue_skies:" + key);
    }

    public BlueSkies() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BlueSkiesConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BlueSkiesConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
    }

    private void commonInit(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new SkiesEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SkiesPlayerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new FuelHandler());
        ImmutableMap gatekeeperBiomeOps = ImmutableMap.of((Object)"snowy", (Object)ImmutableList.of((Object)Biomes.field_76774_n.getRegistryName(), (Object)Biomes.field_150584_S.getRegistryName(), (Object)this.bopBiome("snowy_coniferous_forest"), (Object)this.bopBiome("boreal_forest")), (Object)"plains", (Object)ImmutableList.of((Object)Biomes.field_76772_c.getRegistryName(), (Object)Biomes.field_185441_Q.getRegistryName(), (Object)this.bopBiome("shrubland"), (Object)this.bopBiome("grassland")), (Object)"mountain", (Object)ImmutableList.of((Object)Biomes.field_76770_e.getRegistryName(), (Object)Biomes.field_185443_S.getRegistryName(), (Object)Biomes.field_185434_af.getRegistryName(), (Object)Biomes.field_76775_o.getRegistryName(), (Object)Biomes.field_185431_ac.getRegistryName(), (Object)Biomes.field_150580_W.getRegistryName(), (Object)this.bopBiome("cold_desert"), (Object)this.bopBiome("medow")));
        ForgeRegistries.BIOMES.getValues().forEach(arg_0 -> BlueSkies.lambda$commonInit$1((Map)gatekeeperBiomeOps, arg_0));
        Flammability.init();
        Composting.init();
    }

    private ResourceLocation bopBiome(String name) {
        return new ResourceLocation("biomesoplenty", name);
    }

    public void clientInit(FMLClientSetupEvent event) {
        SkiesEntityRendering.init();
        SkiesTileEntityRendering.init();
        MinecraftForge.EVENT_BUS.register((Object)new SkiesMusicHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        SkyBlockColoring.init();
        SkyItemColoring.init();
    }

    private static /* synthetic */ void lambda$commonInit$1(Map gatekeeperBiomeOps, Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(SkiesFeatures.GATEKEEPER_HOUSE, (IFeatureConfig)new GatekeeperHouseConfig(BlueSkies.find("gatekeeper/plains/main")), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
        gatekeeperBiomeOps.entrySet().forEach(entry -> {
            if (((List)entry.getValue()).contains(biome.getRegistryName())) {
                biome.func_201865_a(SkiesFeatures.GATEKEEPER_HOUSE, (IFeatureConfig)new GatekeeperHouseConfig(BlueSkies.find("gatekeeper/" + (String)entry.getKey() + "/main")));
            }
        });
    }
}

