/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen.mobevents;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWall;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.effects.StructureBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class AsmodeusStructureBuilder
extends StructureBuilder {
    public AsmodeusStructureBuilder() {
        this.name = "asmodeus";
    }

    @Override
    public void build(World world, PlayerEntity player, BlockPos pos, int level, int ticks) {
        int originX = pos.func_177958_n();
        int originY = pos.func_177956_o();
        int originZ = pos.func_177952_p();
        originX += 20;
        int height = 40;
        if (originY < 5) {
            originY = 5;
        }
        if (world.func_72940_L() <= height) {
            originY = 5;
        } else if (originY + height >= world.func_72940_L()) {
            originY = Math.max(5, world.func_72940_L() - height - 1);
        }
        if (ticks == 20) {
            this.buildArenaFloor(world, originX, originY, originZ);
        }
        if (ticks >= 60 && ticks % 10 == 0) {
            world.func_217385_a(null, (double)(originX - 20 + world.field_73012_v.nextInt(40)), (double)(originY + 25 + world.field_73012_v.nextInt(10)), (double)(originZ - 20 + world.field_73012_v.nextInt(40)), 2.0f, Explosion.Mode.NONE);
        }
        if (ticks == 60) {
            this.buildObstacles(world, originX, originY, originZ);
        }
        if (ticks == 100) {
            this.buildArenaWalls(world, originX, originY, originZ);
        }
        if (ticks == 300) {
            for (int i = 0; i < 5; ++i) {
                EntityHellfireWall baseProjectileEntity = new EntityHellfireWall(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireWall.class), world, originX, originY + 10 * i, originZ);
                baseProjectileEntity.projectileLife = 180;
                world.func_217376_c((Entity)baseProjectileEntity);
            }
        }
        if (ticks == 500) {
            MobEventPlayerServer mobEventPlayerServer;
            BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)CreatureManager.getInstance().getCreature("asmodeus").createEntity(world);
            baseCreatureEntity.func_70012_b(originX, originY + 1, originZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)baseCreatureEntity);
            baseCreatureEntity.setArenaCenter(new BlockPos(originX, originY + 1, originZ));
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
            if (worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.name)) != null) {
                mobEventPlayerServer.mobEvent.onSpawn((LivingEntity)baseCreatureEntity, world, player, pos, level, ticks);
            }
        }
    }

    public void buildArenaFloor(World world, int originX, int originY, int originZ) {
        int radius = 80;
        int height = 30;
        int minX = originX - radius;
        int maxX = originX + radius;
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - radius;
        int maxZ = originZ + radius;
        BlockState floor = ObjectManager.getBlock("demonstonetile").func_176223_P();
        BlockState light = ObjectManager.getBlock("demoncrystal").func_176223_P();
        BlockState trimming = ObjectManager.getBlock("demonstonechiseled").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                int topY = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x, 0, z)).func_177956_o();
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y == minY) {
                        if (x == minX || x == maxX || z == minZ || z == maxZ) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        if (x % 6 == 0 && z % 6 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, floor, 2);
                        continue;
                    }
                    if (y > minY + 3 && y >= topY) continue block1;
                    world.func_217377_a(buildPos, false);
                }
            }
        }
    }

    public void buildArenaWalls(World world, int originX, int originY, int originZ) {
        int radius = 80;
        int thickness = 4;
        int height = 20;
        int minX = originX - (radius + thickness);
        int maxX = originX + (radius + thickness);
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - (radius + thickness);
        int maxZ = originZ + (radius + thickness);
        BlockState base = ObjectManager.getBlock("demonstonebrick").func_176223_P();
        BlockState light = ObjectManager.getBlock("demoncrystal").func_176223_P();
        BlockState trimming = ObjectManager.getBlock("demonstonechiseled").func_176223_P();
        BlockState top = ObjectManager.getBlock("demonstonepolished").func_176223_P();
        BlockState fireBase = Blocks.field_150343_Z.func_176223_P();
        BlockState fire = ObjectManager.getBlock("hellfire").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (x > minX + thickness && x < maxX - thickness && z > minZ + thickness && z < maxZ - thickness) continue;
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y < maxY - 2) {
                        if (y - 1 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        if (y % 8 == 0) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, base, 2);
                        continue;
                    }
                    if (y == maxY - 2) {
                        world.func_180501_a(buildPos, top, 2);
                        continue;
                    }
                    if (y == maxY - 1) {
                        world.func_180501_a(buildPos, fireBase, 2);
                        continue;
                    }
                    world.func_180501_a(buildPos, fire, 2);
                }
            }
        }
    }

    public void buildObstacles(World world, int originX, int originY, int originZ) {
        int gap = 20;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x >= -1 && x <= 1 && z >= -1 && z <= 1) continue;
                this.buildPillar(world, originX + x * gap, originY, originZ + z * gap);
            }
        }
    }

    public void buildPillar(World world, int originX, int originY, int originZ) {
        int radius = 2;
        int height = 30;
        int minX = originX - radius;
        int maxX = originX + radius;
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - radius;
        int maxZ = originZ + radius;
        BlockState base = ObjectManager.getBlock("demonstonepillar").func_176223_P();
        BlockState light = ObjectManager.getBlock("demoncrystal").func_176223_P();
        BlockState trimming = ObjectManager.getBlock("demonstonechiseled").func_176223_P();
        BlockState top = ObjectManager.getBlock("demonstonepolished").func_176223_P();
        BlockState fireBase = Blocks.field_150343_Z.func_176223_P();
        BlockState fire = ObjectManager.getBlock("hellfire").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y < maxY - 2) {
                        if (y % 7 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        if (y % 8 == 0) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, base, 2);
                        continue;
                    }
                    if (y == maxY - 2) {
                        world.func_180501_a(buildPos, top, 2);
                        continue;
                    }
                    if (y == maxY - 1) {
                        world.func_180501_a(buildPos, fireBase, 2);
                        continue;
                    }
                    world.func_180501_a(buildPos, fire, 2);
                }
            }
        }
    }
}

