/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigDungeons;
import com.lycanitesmobs.core.dungeon.instance.DungeonInstance;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DungeonStructure
extends Structure<NoFeatureConfig> {
    public static IStructurePieceType PIECE_TYPE = IStructurePieceType.func_214750_a(Piece::new, (String)"lmdungeonpiece");

    public DungeonStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean func_225558_a_(BiomeManager biomeManager, @Nonnull ChunkGenerator<?> chunkGenerator, @Nonnull Random random, int chunkX, int chunkZ, Biome biome) {
        return true;
    }

    public String func_143025_a() {
        return "lmdungeon";
    }

    public int func_202367_b() {
        return (Integer)ConfigDungeons.INSTANCE.dungeonDistance.get();
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, NoFeatureConfig config) {
        return super.func_212245_a(world, chunkGenerator, random, blockPos, (IFeatureConfig)config);
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Nullable
    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos blockPos, int p_211405_4_, boolean p_211405_5_) {
        if (!chunkGenerator.func_202090_b().func_205004_a((Structure)this)) {
            return null;
        }
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(world);
        if (extendedWorld == null) {
            return null;
        }
        double closestDistance = Double.MAX_VALUE;
        DungeonInstance closestDungeon = null;
        List<DungeonInstance> nearbyDungeons = extendedWorld.getNearbyDungeonInstances(new ChunkPos(blockPos), 240);
        for (DungeonInstance dungeonInstance : nearbyDungeons) {
            double distance = dungeonInstance.originPos.func_177951_i((Vec3i)blockPos);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestDungeon = dungeonInstance;
        }
        return closestDungeon.originPos;
    }

    public static class Piece
    extends ScatteredStructurePiece {
        public boolean enabled;
        public int dungeonDistance;

        public Piece(Random random, int chunkX, int chunkZ) {
            super(PIECE_TYPE, random, chunkX, 64, chunkZ, 7, 7, 9);
        }

        protected Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(PIECE_TYPE, nbt);
            this.enabled = (Boolean)ConfigDungeons.INSTANCE.dungeonsEnabled.get();
            this.dungeonDistance = (Integer)ConfigDungeons.INSTANCE.dungeonDistance.get();
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
        }

        public boolean func_225577_a_(IWorld worldWriter, ChunkGenerator<?> chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            boolean enabled = (Boolean)ConfigDungeons.INSTANCE.dungeonsEnabled.get();
            LycanitesMobs.logDebug("", "Dungeon Component At Chunk: X" + chunkPos.field_77276_a + " Z" + chunkPos.field_77275_b);
            World world = worldWriter.func_201672_e();
            ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(world);
            if (!enabled || extendedWorld == null) {
                return false;
            }
            try {
                int dungeonSizeMax = (Integer)ConfigDungeons.INSTANCE.dungeonDistance.get();
                List<DungeonInstance> nearbyDungeons = extendedWorld.getNearbyDungeonInstances(chunkPos, dungeonSizeMax * 2);
                if (nearbyDungeons.isEmpty()) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x == 0 && z == 0 || x != 0 && z != 0) continue;
                            LycanitesMobs.logDebug("", "Creating A New Dungeon At Chunk: X" + (chunkPos.field_77276_a + dungeonSizeMax * x) + " Z" + (chunkPos.field_77275_b + dungeonSizeMax * z));
                            DungeonInstance dungeonInstance = new DungeonInstance();
                            int yPos = world.func_181545_F();
                            BlockPos dungeonPos = new ChunkPos(chunkPos.field_77276_a + dungeonSizeMax * x, chunkPos.field_77275_b + dungeonSizeMax * z).func_180331_a(7, yPos, 7);
                            dungeonInstance.setOrigin(dungeonPos);
                            dungeonInstance.init(world.func_201672_e());
                            extendedWorld.addDungeonInstance(dungeonInstance, new UUID(random.nextLong(), random.nextLong()));
                            LycanitesMobs.logDebug("", "Dungeon (Structure) Created: " + dungeonInstance.toString());
                        }
                    }
                }
                nearbyDungeons = extendedWorld.getNearbyDungeonInstances(chunkPos, 0);
                for (DungeonInstance dungeonInstance : nearbyDungeons) {
                    dungeonInstance.buildChunk(worldWriter, world, chunkPos, random);
                }
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when trying to generate a dungeon.");
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, boundingBox, reference, seed);
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager templateManager, int chunkX, int chunkZ, Biome biome) {
            this.field_75075_a.add(new Piece((Random)this.field_214631_d, chunkX * 16, chunkZ * 16));
        }
    }
}

