/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigDungeons;
import com.lycanitesmobs.core.dungeon.instance.DungeonInstance;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DungeonFeature
extends Feature<NoFeatureConfig> {
    public DungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld worldWriter, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        boolean enabled = (Boolean)ConfigDungeons.INSTANCE.dungeonsEnabled.get();
        int dungeonDistance = (Integer)ConfigDungeons.INSTANCE.dungeonDistance.get();
        World world = worldWriter.func_201672_e();
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(world);
        if (!enabled || extendedWorld == null) {
            return false;
        }
        try {
            int dungeonSizeMax = dungeonDistance;
            ChunkPos chunkPos = new ChunkPos(pos);
            List<DungeonInstance> nearbyDungeons = extendedWorld.getNearbyDungeonInstances(chunkPos, dungeonSizeMax * 2);
            if (nearbyDungeons.isEmpty()) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0 || x != 0 && z != 0) continue;
                        LycanitesMobs.logDebug("Dungeon", "Creating A New Dungeon At Chunk: X" + (chunkPos.field_77276_a + dungeonSizeMax * x) + " Z" + (chunkPos.field_77275_b + dungeonSizeMax * z));
                        DungeonInstance dungeonInstance = new DungeonInstance();
                        int yPos = worldWriter.func_181545_F();
                        if (yPos < 64) {
                            yPos = 64;
                        }
                        BlockPos dungeonPos = new ChunkPos(chunkPos.field_77276_a + dungeonSizeMax * x, chunkPos.field_77275_b + dungeonSizeMax * z).func_180331_a(7, yPos, 7);
                        dungeonInstance.setOrigin(dungeonPos);
                        dungeonInstance.init(world);
                        extendedWorld.addDungeonInstance(dungeonInstance, new UUID(random.nextLong(), random.nextLong()));
                        LycanitesMobs.logDebug("", "Dungeon (Feature) Created: " + dungeonInstance.toString());
                    }
                }
            }
            nearbyDungeons = extendedWorld.getNearbyDungeonInstances(chunkPos, 0);
            for (DungeonInstance dungeonInstance : nearbyDungeons) {
                dungeonInstance.buildChunk(worldWriter, world, chunkPos, random);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when trying to generate a dungeon.");
            e.printStackTrace();
        }
        return true;
    }
}

