/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeBlockSpawnTrigger
extends BlockSpawnTrigger {
    public TreeBlockSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
    }

    @Override
    public boolean isTriggerBlock(BlockState blockState, World world, BlockPos blockPos, int fortune, @Nullable LivingEntity entity) {
        return this.isTreeLogBlock(blockState.func_177230_c(), world, blockPos) || this.isTreeLeavesBlock(blockState.func_177230_c(), world, blockPos);
    }

    public boolean isTreeLogBlock(Block block, World world, BlockPos pos) {
        if (block instanceof LogBlock) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY <= Math.min(world.func_72940_L(), y + 32); ++searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block) continue;
                        if (searchBlock instanceof LeavesBlock) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }

    public boolean isTreeLeavesBlock(Block block, World world, BlockPos pos) {
        if (block instanceof LeavesBlock) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int searchX = x - 1; searchX <= x + 1; ++searchX) {
                block1: for (int searchZ = z - 1; searchZ <= z + 1; ++searchZ) {
                    for (int searchY = y; searchY >= Math.max(0, y - 32); --searchY) {
                        Block searchBlock = world.func_180495_p(new BlockPos(searchX, searchY, searchZ)).func_177230_c();
                        if (searchBlock == block) continue;
                        if (searchBlock instanceof LogBlock) {
                            return true;
                        }
                        if (!world.func_175623_d(new BlockPos(x, searchY, z))) continue block1;
                    }
                }
            }
        }
        return false;
    }
}

