/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class OreBlockSpawnTrigger
extends BlockSpawnTrigger {
    public boolean ores = true;
    public boolean gems = false;

    public OreBlockSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("ores")) {
            this.ores = json.get("ores").getAsBoolean();
        }
        if (json.has("gems")) {
            this.gems = json.get("gems").getAsBoolean();
        }
    }

    @Override
    public boolean isTriggerBlock(BlockState blockState, World world, BlockPos blockPos, int fortune, @Nullable LivingEntity entity) {
        String[] blockNameParts;
        Block block = blockState.func_177230_c();
        if (block instanceof SilverfishBlock) {
            return this.ores;
        }
        if (block == Blocks.field_150365_q) {
            return this.ores;
        }
        if (block.getRegistryName() == null) {
            return false;
        }
        String blockName = block.getRegistryName().func_110623_a();
        for (String blockNamePart : blockNameParts = blockName.split("\\.")) {
            int blockNamePartLength = blockNamePart.length();
            if (blockNamePartLength < 3 || !blockNamePart.substring(0, 3).equalsIgnoreCase("ore") && !blockNamePart.substring(blockNamePartLength - 3, blockNamePartLength).equalsIgnoreCase("ore") && !blockNamePart.substring(0, 3).equalsIgnoreCase("crystal") && !blockNamePart.substring(blockNamePartLength - 3, blockNamePartLength).equalsIgnoreCase("crystal")) continue;
            if (this.ores && this.gems) {
                return true;
            }
            if (!(world instanceof ServerWorld)) continue;
            List drops = entity == null ? Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)blockPos, null) : Block.func_220077_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)blockPos, null, (Entity)entity, (ItemStack)entity.func_184607_cu());
            Iterator iterator = drops.iterator();
            if (!iterator.hasNext()) continue;
            ItemStack dropStack = (ItemStack)iterator.next();
            if (dropStack.func_77973_b() instanceof BlockItem) {
                return this.ores;
            }
            return this.gems;
        }
        return false;
    }

    @Override
    public int getBlockLevel(BlockState blockState, World world, BlockPos blockPos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150482_ag) {
            return 3;
        }
        if (block == Blocks.field_150412_bA) {
            return 3;
        }
        if (block == Blocks.field_150369_x) {
            return 2;
        }
        if (block == Blocks.field_150352_o) {
            return 2;
        }
        if (block == Blocks.field_150366_p) {
            return 1;
        }
        return 0;
    }
}

