/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public abstract class EntitySpawnTrigger
extends SpawnTrigger {
    public List<CreatureAttribute> creatureAttributes = new ArrayList<CreatureAttribute>();
    public String entityTypesListType = "whitelist";
    public List<String> entityIds = new ArrayList<String>();
    public String entityIdsListType = "blacklist";

    public EntitySpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        Iterator jsonIterator;
        JsonArray jsonArray;
        if (json.has("entityTypes")) {
            jsonArray = json.get("entityTypes").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                CreatureAttribute creatureAttribute = null;
                String creatureAttributeName = ((JsonElement)jsonIterator.next()).getAsString();
                if ("undead".equals(creatureAttributeName)) {
                    creatureAttribute = CreatureAttribute.field_223223_b_;
                } else if ("arthropod".equals(creatureAttributeName)) {
                    creatureAttribute = CreatureAttribute.field_223224_c_;
                } else if ("water".equals(creatureAttributeName)) {
                    creatureAttribute = CreatureAttribute.field_203100_e;
                } else if ("illager".equals(creatureAttributeName)) {
                    creatureAttribute = CreatureAttribute.field_223225_d_;
                } else if ("undefined".equals(creatureAttributeName)) {
                    creatureAttribute = CreatureAttribute.field_223222_a_;
                }
                if (creatureAttribute == null) continue;
                this.creatureAttributes.add(creatureAttribute);
            }
        }
        if (json.has("entityTypesListType")) {
            this.entityTypesListType = json.get("entityTypesListType").getAsString();
        }
        if (json.has("entityIds")) {
            jsonArray = json.get("entityIds").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                String entityId = ((JsonElement)jsonIterator.next()).getAsString();
                if (entityId == null) continue;
                this.entityIds.add(entityId);
            }
        }
        if (json.has("entityIdsListType")) {
            this.entityIdsListType = json.get("entityIdsListType").getAsString();
        }
        super.loadFromJSON(json);
    }

    public boolean isMatchingEntity(LivingEntity killedEntity) {
        if (!this.creatureAttributes.isEmpty() && (this.creatureAttributes.contains(killedEntity.func_70668_bt()) ? "blacklist".equalsIgnoreCase(this.entityTypesListType) : "whitelist".equalsIgnoreCase(this.entityTypesListType))) {
            return false;
        }
        if (!this.entityIds.isEmpty()) {
            ResourceLocation entityResourceLocation = killedEntity.func_200600_R().getRegistryName();
            if (entityResourceLocation == null) {
                return false;
            }
            String entityId = entityResourceLocation.toString();
            if (this.entityIds.contains(entityId) ? "blacklist".equalsIgnoreCase(this.entityIdsListType) : "whitelist".equalsIgnoreCase(this.entityIdsListType)) {
                return false;
            }
        }
        return true;
    }
}

