/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.spawner.location.RandomSpawnLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureSpawnLocation
extends RandomSpawnLocation {
    public String structureType = "Stronghold";
    public int structureRange = 100;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("structureType")) {
            this.structureType = json.get("structureType").getAsString();
        }
        if (json.has("structureRange")) {
            this.structureRange = json.get("structureRange").getAsInt();
        }
    }

    @Override
    public List<BlockPos> getSpawnPositions(World world, PlayerEntity player, BlockPos triggerPos) {
        LycanitesMobs.logDebug("JSONSpawner", "Getting Nearest " + this.structureType + " Type Structures Within Range");
        if (!(world instanceof ServerWorld)) {
            LycanitesMobs.logWarning("", "[JSONSpawner] Structure spawn location was called with a non ServerWorld World instance.");
            return new ArrayList<BlockPos>();
        }
        BlockPos structurePos = null;
        try {
            structurePos = ((ServerWorld)world).func_211157_a(this.structureType, triggerPos, this.structureRange, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (structurePos == null) {
            LycanitesMobs.logDebug("JSONSpawner", "No " + this.structureType + " Structures found.");
            return new ArrayList<BlockPos>();
        }
        double structureDistance = Math.sqrt(structurePos.func_177951_i((Vec3i)triggerPos));
        if (structureDistance > (double)(this.structureRange * this.structureRange)) {
            LycanitesMobs.logDebug("JSONSpawner", "No " + this.structureType + " Structures within range, nearest was: " + structureDistance + "/" + this.structureRange * this.structureRange + " at: " + structurePos);
            return new ArrayList<BlockPos>();
        }
        LycanitesMobs.logDebug("JSONSpawner", "Found a " + this.structureType + " Structure within range, at: " + structurePos);
        return super.getSpawnPositions(world, player, structurePos);
    }
}

