/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.spawner.CoordSorterFurthest;
import com.lycanitesmobs.core.spawner.CoordSorterNearest;
import com.lycanitesmobs.core.spawner.location.BlockSpawnLocation;
import com.lycanitesmobs.core.spawner.location.MaterialSpawnLocation;
import com.lycanitesmobs.core.spawner.location.RandomSpawnLocation;
import com.lycanitesmobs.core.spawner.location.StructureSpawnLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SpawnLocation {
    public Vec3i rangeMin = new Vec3i(0, 0, 0);
    public Vec3i rangeMax = new Vec3i(0, 0, 0);
    public int yMin = -1;
    public int yMax = -1;
    public String sorting = "difficulty";

    public static SpawnLocation createFromJSON(JsonObject json) {
        String type = json.get("type").getAsString();
        SpawnLocation spawnLocation = null;
        if ("base".equalsIgnoreCase(type)) {
            spawnLocation = new SpawnLocation();
        } else if ("random".equalsIgnoreCase(type)) {
            spawnLocation = new RandomSpawnLocation();
        } else if ("block".equalsIgnoreCase(type)) {
            spawnLocation = new BlockSpawnLocation();
        } else if ("material".equalsIgnoreCase(type)) {
            spawnLocation = new MaterialSpawnLocation();
        } else if ("structure".equalsIgnoreCase(type)) {
            spawnLocation = new StructureSpawnLocation();
        }
        spawnLocation.loadFromJSON(json);
        return spawnLocation;
    }

    public void loadFromJSON(JsonObject json) {
        this.rangeMin = JSONHelper.getVec3i(json, "rangeMin");
        this.rangeMax = JSONHelper.getVec3i(json, "rangeMax");
        if (json.has("yMin")) {
            this.yMin = json.get("yMin").getAsInt();
        }
        if (json.has("yMax")) {
            this.yMax = json.get("yMax").getAsInt();
        }
        if (json.has("sorting")) {
            this.sorting = json.get("sorting").getAsString();
        }
    }

    public List<BlockPos> getSpawnPositions(World world, PlayerEntity player, BlockPos triggerPos) {
        ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>();
        int yPos = this.getOffset(world.field_73012_v, this.rangeMin.func_177956_o(), this.rangeMax.func_177956_o());
        if (!(this.yMax >= 0 && yPos > this.yMax || this.yMin >= 0 && yPos < this.yMin)) {
            Vec3i offset = new Vec3i(this.getOffset(world.field_73012_v, this.rangeMin.func_177958_n(), this.rangeMax.func_177958_n()), yPos, this.getOffset(world.field_73012_v, this.rangeMin.func_177952_p(), this.rangeMax.func_177952_p()));
            spawnPositions.add(triggerPos.func_177971_a(offset));
        }
        return this.sortSpawnPositions(spawnPositions, world, triggerPos);
    }

    public int getOffset(Random random, int min, int max) {
        if (max <= min) {
            return 0;
        }
        int offset = min + random.nextInt(max - min);
        if (random.nextBoolean()) {
            offset = -offset;
        }
        return offset;
    }

    public List<BlockPos> sortSpawnPositions(List<BlockPos> spawnPositions, World world, BlockPos triggerPos) {
        String sorting = this.sorting;
        if ("difficulty".equalsIgnoreCase(this.sorting)) {
            sorting = "random";
            if (world.func_175659_aa().func_151525_a() <= 1) {
                sorting = "far";
            } else if (world.func_175659_aa().func_151525_a() >= 3) {
                sorting = "near";
            }
        }
        if ("random".equalsIgnoreCase(sorting)) {
            Collections.shuffle(spawnPositions);
        } else if ("near".equalsIgnoreCase(sorting)) {
            Collections.sort(spawnPositions, new CoordSorterNearest(triggerPos));
        } else if ("far".equalsIgnoreCase(sorting)) {
            Collections.sort(spawnPositions, new CoordSorterFurthest(triggerPos));
        }
        return spawnPositions;
    }
}

