/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.condition;

import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;

public class WorldSpawnCondition
extends SpawnCondition {
    public String dimensionListType = "whitelist";
    public List<String> dimensionIds = new ArrayList<String>();
    public List<DimensionType> dimensions = null;
    public String biomeTagListType = "whitelist";
    public List<String> biomeTags = new ArrayList<String>();
    public List<Biome> biomesFromTags = null;
    public String biomeIdListType = "whitelist";
    public List<String> biomeIds = new ArrayList<String>();
    public List<Biome> biomes = null;
    public double worldDayMin = -1.0;
    public double worldDayMax = -1.0;
    public double worldDayN = -1.0;
    public int dayTimeMin = -1;
    public int dayTimeMax = -1;
    public String weather = "any";
    public short difficultyMin = (short)-1;
    public short difficultyMax = (short)-1;
    public float moonPhase = -1.0f;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("dimensionIds")) {
            this.dimensionIds.clear();
            this.dimensions = null;
            this.dimensionIds = JSONHelper.getJsonStrings(json.get("dimensionIds").getAsJsonArray());
        }
        if (json.has("dimensionListType")) {
            this.dimensionListType = json.get("dimensionListType").getAsString();
        }
        if (json.has("biomes")) {
            this.biomeTags.clear();
            this.biomesFromTags = null;
            this.biomeTags = JSONHelper.getJsonStrings(json.get("biomes").getAsJsonArray());
        }
        if (json.has("biomeTagListType")) {
            this.biomeTagListType = json.get("biomeTagListType").getAsString();
        }
        if (json.has("biomeIds")) {
            this.biomeIds.clear();
            this.biomes = null;
            this.biomeIds = JSONHelper.getJsonStrings(json.get("biomeIds").getAsJsonArray());
        }
        if (json.has("biomeIdListType")) {
            this.biomeIdListType = json.get("biomeIdListType").getAsString();
        }
        if (json.has("worldDayMin")) {
            this.worldDayMin = json.get("worldDayMin").getAsInt();
        }
        if (json.has("worldDayMax")) {
            this.worldDayMax = json.get("worldDayMax").getAsInt();
        }
        if (json.has("worldDayN")) {
            this.worldDayN = json.get("worldDayN").getAsInt();
        }
        if (json.has("dayTimeMin")) {
            this.dayTimeMin = json.get("dayTimeMin").getAsInt();
        }
        if (json.has("dayTimeMax")) {
            this.dayTimeMax = json.get("dayTimeMax").getAsInt();
        }
        if (json.has("weather")) {
            this.weather = json.get("weather").getAsString();
        }
        if (json.has("difficultyMin")) {
            this.difficultyMin = json.get("difficultyMin").getAsShort();
        }
        if (json.has("difficultyMax")) {
            this.difficultyMax = json.get("difficultyMax").getAsShort();
        }
        if (json.has("moonPhase")) {
            this.moonPhase = json.get("moonPhase").getAsFloat();
        }
        super.loadFromJSON(json);
    }

    @Override
    public boolean isMet(World world, PlayerEntity player, BlockPos position) {
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        int time = (int)Math.floor((double)world.func_72820_D() % 24000.0);
        int day = (int)Math.floor((double)(worldExt.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D()) / 23999.0);
        if (this.worldDayMin >= 0.0 && (double)day < this.worldDayMin) {
            return false;
        }
        if (this.worldDayMax >= 0.0 && (double)day > this.worldDayMax) {
            return false;
        }
        if (this.worldDayN >= 0.0 && (day == 0 || (double)day % this.worldDayN != 0.0)) {
            return false;
        }
        if (this.dayTimeMin >= 0 && time < this.dayTimeMin) {
            return false;
        }
        if (this.dayTimeMax >= 0 && time > this.dayTimeMax) {
            return false;
        }
        if ("clear".equalsIgnoreCase(this.weather) && (world.func_72896_J() || world.func_72911_I())) {
            return false;
        }
        if ("rain".equalsIgnoreCase(this.weather) && (!world.func_72896_J() || world.func_72911_I())) {
            return false;
        }
        if ("storm".equalsIgnoreCase(this.weather) && !world.func_72911_I()) {
            return false;
        }
        if (!(!"rainstorm".equalsIgnoreCase(this.weather) || world.func_72896_J() && world.func_72911_I())) {
            return false;
        }
        if ("notclear".equalsIgnoreCase(this.weather) && !world.func_72896_J() && !world.func_72911_I()) {
            return false;
        }
        if (this.difficultyMin >= 0 && world.func_175659_aa().func_151525_a() < this.difficultyMin) {
            return false;
        }
        if (this.difficultyMax >= 0 && world.func_175659_aa().func_151525_a() > this.difficultyMax) {
            return false;
        }
        if (this.moonPhase >= 0.0f && world.func_130001_d() != this.moonPhase) {
            return false;
        }
        if (!this.isAllowedDimension(world)) {
            return false;
        }
        if (!this.isAllowedBiome(world, position)) {
            return false;
        }
        return super.isMet(world, player, position);
    }

    public boolean isAllowedDimension(World world) {
        DimensionType dimension = world.func_201675_m().func_186058_p();
        if (!this.dimensionIds.isEmpty()) {
            for (String dimensionId : this.dimensionIds) {
                if (!dimensionId.equals(dimension.getRegistryName().toString())) continue;
                return !"blacklist".equalsIgnoreCase(this.dimensionListType);
            }
        }
        return "blacklist".equalsIgnoreCase(this.dimensionListType);
    }

    public boolean isAllowedBiome(World world, BlockPos position) {
        if (position != null) {
            Biome biome = world.func_225523_d_().func_226836_a_(position);
            if (!this.biomeIds.isEmpty()) {
                if (this.biomes == null) {
                    this.biomes = JSONHelper.getBiomes(this.biomeIds);
                }
                if (this.biomes.contains(biome)) {
                    return !"blacklist".equalsIgnoreCase(this.biomeIdListType);
                }
            }
            if (!this.biomeTags.isEmpty()) {
                if (this.biomesFromTags == null) {
                    this.biomesFromTags = JSONHelper.getBiomesFromTags(this.biomeTags);
                }
                if (this.biomesFromTags.contains(biome)) {
                    return !"blacklist".equalsIgnoreCase(this.biomeTagListType);
                }
            }
        }
        if (this.biomeIds.isEmpty() && this.biomeTags.isEmpty()) {
            return true;
        }
        return "blacklist".equalsIgnoreCase(this.biomeIdListType) && "blacklist".equalsIgnoreCase(this.biomeTagListType);
    }
}

