/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.condition;

import com.google.gson.JsonObject;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EventSpawnCondition
extends SpawnCondition {
    public String eventName = "";
    public int eventTimeMin = -1;
    public int eventTimeMax = -1;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("eventName")) {
            this.eventName = json.get("eventName").getAsString();
        }
        if (json.has("eventTimeMin")) {
            this.eventTimeMin = json.get("eventTimeMin").getAsInt();
        }
        if (json.has("eventTimeMax")) {
            this.eventTimeMax = json.get("eventTimeMax").getAsInt();
        }
        super.loadFromJSON(json);
    }

    @Override
    public boolean isMet(World world, PlayerEntity player, BlockPos position) {
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return false;
        }
        if (!("".equals(this.eventName) || worldExt.getWorldEventName() != null && worldExt.getWorldEventName().equalsIgnoreCase(this.eventName))) {
            return false;
        }
        if (this.eventTimeMin >= 0 && worldExt.getWorldEventCount() < this.eventTimeMin) {
            return false;
        }
        if (this.eventTimeMax >= 0 && worldExt.getWorldEventCount() > this.eventTimeMax) {
            return false;
        }
        return super.isMet(world, player, position);
    }
}

