/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.ChunkSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.EntitySpawnedSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.ExplosionSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.FishingSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.KillSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.MixBlockSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.MobEventSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.PlayerSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.SleepSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.WorldSpawnTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpawnerEventListener {
    private static SpawnerEventListener INSTANCE;
    public static boolean testOnCreative;
    private List<WorldSpawnTrigger> worldSpawnTriggers = new ArrayList<WorldSpawnTrigger>();
    private List<PlayerSpawnTrigger> playerSpawnTriggers = new ArrayList<PlayerSpawnTrigger>();
    private List<KillSpawnTrigger> killSpawnTriggers = new ArrayList<KillSpawnTrigger>();
    private List<EntitySpawnedSpawnTrigger> entitySpawnedSpawnTriggers = new ArrayList<EntitySpawnedSpawnTrigger>();
    private List<ChunkSpawnTrigger> chunkSpawnTriggers = new ArrayList<ChunkSpawnTrigger>();
    private List<BlockSpawnTrigger> blockSpawnTriggers = new ArrayList<BlockSpawnTrigger>();
    private List<SleepSpawnTrigger> sleepSpawnTriggers = new ArrayList<SleepSpawnTrigger>();
    private List<FishingSpawnTrigger> fishingSpawnTriggers = new ArrayList<FishingSpawnTrigger>();
    private List<ExplosionSpawnTrigger> explosionSpawnTriggers = new ArrayList<ExplosionSpawnTrigger>();
    private List<MobEventSpawnTrigger> mobEventSpawnTriggers = new ArrayList<MobEventSpawnTrigger>();
    private List<MixBlockSpawnTrigger> mixBlockSpawnTriggers = new ArrayList<MixBlockSpawnTrigger>();
    private Map<World, List<ChunkPos>> freshChunks = new HashMap<World, List<ChunkPos>>();
    public Map<PlayerEntity, Long> playerUpdateTicks = new HashMap<PlayerEntity, Long>();
    public boolean chunkSpawnTriggersActive = false;
    private BlockPos lastMixPos;

    public static SpawnerEventListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpawnerEventListener();
        }
        return INSTANCE;
    }

    public boolean addTrigger(SpawnTrigger spawnTrigger) {
        if (spawnTrigger instanceof WorldSpawnTrigger && !this.worldSpawnTriggers.contains(spawnTrigger)) {
            this.worldSpawnTriggers.add((WorldSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof PlayerSpawnTrigger && !this.playerSpawnTriggers.contains(spawnTrigger)) {
            this.playerSpawnTriggers.add((PlayerSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof KillSpawnTrigger && !this.killSpawnTriggers.contains(spawnTrigger)) {
            this.killSpawnTriggers.add((KillSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof EntitySpawnedSpawnTrigger && !this.entitySpawnedSpawnTriggers.contains(spawnTrigger)) {
            this.entitySpawnedSpawnTriggers.add((EntitySpawnedSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof ChunkSpawnTrigger && !this.chunkSpawnTriggers.contains(spawnTrigger)) {
            this.chunkSpawnTriggers.add((ChunkSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof MixBlockSpawnTrigger && !this.mixBlockSpawnTriggers.contains(spawnTrigger)) {
            this.mixBlockSpawnTriggers.add((MixBlockSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof SleepSpawnTrigger && !this.sleepSpawnTriggers.contains(spawnTrigger)) {
            this.sleepSpawnTriggers.add((SleepSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof BlockSpawnTrigger && !this.blockSpawnTriggers.contains(spawnTrigger)) {
            this.blockSpawnTriggers.add((BlockSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof FishingSpawnTrigger && !this.fishingSpawnTriggers.contains(spawnTrigger)) {
            this.fishingSpawnTriggers.add((FishingSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof ExplosionSpawnTrigger && !this.explosionSpawnTriggers.contains(spawnTrigger)) {
            this.explosionSpawnTriggers.add((ExplosionSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof MobEventSpawnTrigger && !this.mobEventSpawnTriggers.contains(spawnTrigger)) {
            this.mobEventSpawnTriggers.add((MobEventSpawnTrigger)spawnTrigger);
            return true;
        }
        return false;
    }

    public void removeTrigger(SpawnTrigger spawnTrigger) {
        if (this.worldSpawnTriggers.contains(spawnTrigger)) {
            this.worldSpawnTriggers.remove(spawnTrigger);
        }
        if (this.playerSpawnTriggers.contains(spawnTrigger)) {
            this.playerSpawnTriggers.remove(spawnTrigger);
        }
        if (this.killSpawnTriggers.contains(spawnTrigger)) {
            this.killSpawnTriggers.remove(spawnTrigger);
        }
        if (this.entitySpawnedSpawnTriggers.contains(spawnTrigger)) {
            this.entitySpawnedSpawnTriggers.remove(spawnTrigger);
        }
        if (this.chunkSpawnTriggers.contains(spawnTrigger)) {
            this.chunkSpawnTriggers.remove(spawnTrigger);
        }
        if (this.blockSpawnTriggers.contains(spawnTrigger)) {
            this.blockSpawnTriggers.remove(spawnTrigger);
        }
        if (this.sleepSpawnTriggers.contains(spawnTrigger)) {
            this.sleepSpawnTriggers.remove(spawnTrigger);
        }
        if (this.fishingSpawnTriggers.contains(spawnTrigger)) {
            this.fishingSpawnTriggers.remove(spawnTrigger);
        }
        if (this.explosionSpawnTriggers.contains(spawnTrigger)) {
            this.explosionSpawnTriggers.remove(spawnTrigger);
        }
        if (this.mobEventSpawnTriggers.contains(spawnTrigger)) {
            this.mobEventSpawnTriggers.remove(spawnTrigger);
        }
        if (this.mixBlockSpawnTriggers.contains(spawnTrigger)) {
            this.mixBlockSpawnTriggers.remove(spawnTrigger);
        }
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        if (worldExt.lastSpawnerTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastSpawnerTime = world.func_82737_E();
        ArrayList<BlockPos> triggerPositions = new ArrayList<BlockPos>();
        for (PlayerEntity player : world.func_217369_A()) {
            if (triggerPositions.isEmpty()) {
                triggerPositions.add(player.func_180425_c());
                continue;
            }
            boolean nearOtherPlayers = false;
            for (BlockPos triggerPosition : triggerPositions) {
                Vec3d vec3d = new Vec3d((Vec3i)triggerPosition);
                if (!(player.func_195048_a(vec3d) <= 10000.0)) continue;
                nearOtherPlayers = true;
            }
            if (nearOtherPlayers) continue;
            triggerPositions.add(player.func_180425_c());
        }
        for (BlockPos triggerPosition : triggerPositions) {
            for (WorldSpawnTrigger spawnTrigger : this.worldSpawnTriggers) {
                spawnTrigger.onTick(world, triggerPosition, worldExt.lastSpawnerTime);
            }
        }
        this.checkFreshChunks(world);
        if (worldExt.getWorldEvent() != null) {
            for (MobEventSpawnTrigger spawnTrigger : this.mobEventSpawnTriggers) {
                spawnTrigger.onTick(world, worldExt.serverWorldEventPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof PlayerEntity) || entity.func_130014_f_() == null || entity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (!this.playerUpdateTicks.containsKey(player)) {
            this.playerUpdateTicks.put(player, 0L);
        }
        long entityUpdateTick = this.playerUpdateTicks.get(player);
        int tickOffset = 0;
        for (PlayerSpawnTrigger spawnTrigger : this.playerSpawnTriggers) {
            spawnTrigger.onTick(player, entityUpdateTick - (long)tickOffset);
            tickOffset += 105;
        }
        this.playerUpdateTicks.put(player, entityUpdateTick + 1L);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        LivingEntity killedEntity = event.getEntityLiving();
        if (killedEntity == null || killedEntity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        Entity killerEntity = event.getSource().func_76346_g();
        if (!(killerEntity instanceof PlayerEntity)) {
            return;
        }
        for (KillSpawnTrigger spawnTrigger : this.killSpawnTriggers) {
            spawnTrigger.onKill((PlayerEntity)killerEntity, killedEntity);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent event) {
        LivingEntity spawnedEntity = event.getEntityLiving();
        if (spawnedEntity == null || spawnedEntity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        for (EntitySpawnedSpawnTrigger spawnTrigger : this.entitySpawnedSpawnTriggers) {
            spawnTrigger.onEntitySpawned(spawnedEntity);
        }
    }

    public void onChunkGenerate(World world, ChunkPos chunkPos) {
        if (!this.freshChunks.containsKey(world)) {
            this.freshChunks.put(world, new ArrayList());
        }
        if (this.freshChunks.get(world).contains(chunkPos)) {
            return;
        }
        this.freshChunks.get(world).add(chunkPos);
    }

    public void checkFreshChunks(World world) {
        if (!this.freshChunks.containsKey(world)) {
            this.freshChunks.put(world, new ArrayList());
            return;
        }
        ArrayList freshChunks = new ArrayList(this.freshChunks.get(world));
        for (ChunkPos chunkPos : freshChunks) {
            if (!world.func_72863_F().func_222865_a(chunkPos)) continue;
            this.freshChunks.get(world).remove(chunkPos);
            for (ChunkSpawnTrigger spawnTrigger : this.chunkSpawnTriggers) {
                if (!spawnTrigger.onChunkPopulate(world, chunkPos)) continue;
            }
        }
        if (this.freshChunks.get(world).size() > 100) {
            this.freshChunks.get(world).clear();
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        PlayerEntity player = event.getHarvester();
        if (event.getState() == null || !(event.getWorld() instanceof World) || event.getWorld().func_201670_d() || event.isCanceled()) {
            return;
        }
        World world = (World)event.getWorld();
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getState();
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockHarvest(world, player, blockPos, blockState, 0, event.getFortuneLevel(), event.isSilkTouching());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState() == null || !(event.getWorld() instanceof World) || event.getWorld().func_201670_d() || event.isCanceled()) {
            return;
        }
        World world = (World)event.getWorld();
        this.onBlockBreak(world, event.getPos(), event.getState(), event.getPlayer(), 0);
    }

    public void onBlockBreak(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player, int chain) {
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockBreak(world, player, blockPos, blockState, chain);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getState() == null || !(event.getWorld() instanceof World) || event.getWorld().func_201670_d() || event.isCanceled()) {
            return;
        }
        World world = (World)event.getWorld();
        if (event.getEntity() instanceof PlayerEntity) {
            this.onBlockPlace(world, event.getPos(), event.getState(), (PlayerEntity)event.getEntity(), 0);
        }
    }

    public void onBlockPlace(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player, int chain) {
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockPlace(world, player, blockPos, blockState, chain);
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        World world = player.func_130014_f_();
        BlockPos spawnPos = player.func_180425_c().func_177982_a(0, 0, 1);
        if (world.field_72995_K || world.func_72935_r()) {
            return;
        }
        boolean interrupted = false;
        for (SleepSpawnTrigger spawnTrigger : this.sleepSpawnTriggers) {
            if (!spawnTrigger.onSleep(world, player, spawnPos, world.func_180495_p(player.func_180425_c()))) continue;
            interrupted = true;
        }
        if (interrupted) {
            event.setResult(PlayerEntity.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void onFished(ItemFishedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        if (!testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = player.func_130014_f_();
        FishingBobberEntity hookEntity = event.getHookEntity();
        for (FishingSpawnTrigger spawnTrigger : this.fishingSpawnTriggers) {
            spawnTrigger.onFished(world, player, (Entity)hookEntity);
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion == null) {
            return;
        }
        World world = event.getWorld();
        PlayerEntity player = null;
        if (explosion.func_94613_c() instanceof PlayerEntity) {
            player = (PlayerEntity)explosion.func_94613_c();
        }
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (ExplosionSpawnTrigger spawnTrigger : this.explosionSpawnTriggers) {
            spawnTrigger.onExplosion(world, player, explosion);
        }
    }

    @SubscribeEvent
    public void onLavaMix(BlockEvent.NeighborNotifyEvent event) {
        BlockState sideBlockState;
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        boolean trigger = false;
        World world = (World)event.getWorld();
        boolean playerNearby = false;
        Vec3d posVec = new Vec3d((Vec3i)event.getPos());
        for (PlayerEntity playerEntity : world.func_217369_A()) {
            if (!(playerEntity.func_195048_a(posVec) <= 400.0)) continue;
            playerNearby = true;
            break;
        }
        if (!playerNearby) {
            return;
        }
        if (event.getState().func_177230_c() == Blocks.field_150355_j) {
            sideBlockState = event.getWorld().func_180495_p(event.getPos().func_177977_b());
            if (sideBlockState.func_177230_c() == Blocks.field_150353_l && (Integer)sideBlockState.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
                trigger = true;
            }
        } else if (event.getState().func_177230_c() == Blocks.field_150353_l && (sideBlockState = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() == Blocks.field_150355_j && (Integer)sideBlockState.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
            trigger = true;
        }
        if (trigger) {
            if (this.lastMixPos != null && this.lastMixPos.equals((Object)event.getPos())) {
                return;
            }
            this.lastMixPos = event.getPos();
            for (MixBlockSpawnTrigger spawnTrigger : this.mixBlockSpawnTriggers) {
                spawnTrigger.onMix(world, event.getState(), event.getPos());
            }
        }
    }

    static {
        testOnCreative = false;
    }
}

