/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigExtra;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetEntryFamiliar;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.commons.io.IOUtils;

public class DonationFamiliars {
    public static DonationFamiliars instance = new DonationFamiliars();
    public Map<String, Map<String, PetEntry>> playerFamiliars = new HashMap<String, Map<String, PetEntry>>();
    public long jsonLoadedTime = -1L;
    protected List<String> familiarBlacklist = null;

    public void readFromJSON() {
        this.jsonLoadedTime = System.currentTimeMillis() / 1000L;
        String jsonString = null;
        try {
            URL familiarURL = new URL("http://api.lycanitesmobs.com/familiar");
            URLConnection urlConnection = familiarURL.openConnection();
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36");
            try (InputStream inputStream = urlConnection.getInputStream();){
                jsonString = IOUtils.toString((InputStream)inputStream, (Charset)null);
            }
            LycanitesMobs.logInfo("", "Online donations file read successfully.");
        }
        catch (Throwable e) {
            LycanitesMobs.logInfo("", "Unable to access the online donations file, using local copy instead, this might be out of date.");
            e.printStackTrace();
            jsonString = this.getLocalJSON();
        }
        if (!this.parseFamiliarJSON(jsonString)) {
            this.parseFamiliarJSON(this.getLocalJSON());
        }
    }

    public boolean parseFamiliarJSON(String jsonString) {
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(jsonString);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject familiarJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                String minecraft_uuid = familiarJson.get("minecraft_uuid").getAsString();
                String minecraft_username = familiarJson.get("minecraft_username").getAsString();
                if (this.getFamiliarBlacklist().contains(minecraft_username)) continue;
                String familiar_species = familiarJson.get("familiar_species").getAsString();
                if ("phantom".equalsIgnoreCase(familiar_species)) {
                    familiar_species = "reaper";
                }
                int familiar_subspecies = familiarJson.get("familiar_subspecies").getAsInt();
                String familiar_name = familiarJson.get("familiar_name").getAsString();
                String familiar_color = familiarJson.get("familiar_color").getAsString();
                double familiar_size = 0.0;
                if (familiarJson.has("familiar_size")) {
                    familiar_size = familiarJson.get("familiar_size").getAsDouble();
                }
                String familiarEntryName = "familiar-" + minecraft_username + "-" + familiar_species.toLowerCase();
                PetEntryFamiliar familiarEntry = new PetEntryFamiliar(familiarEntryName, null, familiar_species.toLowerCase());
                familiarEntry.setEntitySubspeciesID(familiar_subspecies);
                if (familiar_size <= 0.0) {
                    familiarEntry.setEntitySize(familiar_subspecies < 3 ? 0.6 : 0.3);
                } else {
                    familiarEntry.setEntitySize(familiar_size);
                }
                if (!"".equals(familiar_name)) {
                    familiarEntry.setEntityName(familiar_name);
                }
                familiarEntry.setColor(familiar_color);
                if (!this.playerFamiliars.containsKey(minecraft_uuid)) {
                    this.playerFamiliars.put(minecraft_uuid, new HashMap());
                }
                if (!this.playerFamiliars.containsKey(familiarEntryName)) {
                    this.playerFamiliars.get(minecraft_uuid).put(familiarEntryName, familiarEntry);
                    continue;
                }
                PetEntry existingEntry = this.playerFamiliars.get(minecraft_uuid).get(familiarEntryName);
                existingEntry.copy(familiarEntry);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<String> getFamiliarBlacklist() {
        if (this.familiarBlacklist == null) {
            this.familiarBlacklist = new ArrayList<String>();
            this.familiarBlacklist.addAll((Collection)ConfigExtra.INSTANCE.familiarBlacklist.get());
        }
        return this.familiarBlacklist;
    }

    public Map<String, PetEntry> getFamiliarsForPlayer(PlayerEntity player) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.jsonLoadedTime < 0L || currentTime - this.jsonLoadedTime > 3600L) {
            this.readFromJSON();
        }
        Map<String, PetEntry> playerFamiliarEntries = new HashMap<String, PetEntry>();
        String playerUUID = player.func_110124_au().toString();
        if (this.playerFamiliars.containsKey(playerUUID)) {
            playerFamiliarEntries = this.playerFamiliars.get(playerUUID);
            for (PetEntry familiarEntry : playerFamiliarEntries.values()) {
                if (familiarEntry.host != null) continue;
                familiarEntry.host = player;
            }
        }
        return playerFamiliarEntries;
    }

    private String getLocalJSON() {
        return "[{\"id\":1,\"donation_username\":\"Lycanite\",\"minecraft_uuid\":\"b1829e52-769d-4296-9733-39654bb0449d\",\"minecraft_username\":\"\",\"familiar_species\":\"Argus\",\"familiar_subspecies\":0,\"familiar_size\":0,\"familiar_name\":\"Jasper\",\"familiar_color\":\"009955\",\"created_at\":\"2016-05-07 18:15:07\",\"updated_at\":\"2018-02-03 19:26:57\"}]";
    }
}

