/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSummonSet {
    public byte summonSetID;
    public int subpsecies;
    public String summonType;
    public byte behaviour;

    public MessageSummonSet() {
    }

    public MessageSummonSet(ExtendedPlayer playerExt, byte summonSetID) {
        this.summonSetID = summonSetID;
        this.summonType = playerExt.getSummonSet((int)summonSetID).summonType;
        this.subpsecies = playerExt.getSummonSet((int)summonSetID).subspecies;
        this.behaviour = playerExt.getSummonSet(summonSetID).getBehaviourByte();
    }

    public static void handle(MessageSummonSet message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
                SummonSet summonSet = playerExt.getSummonSet(message.summonSetID);
                summonSet.readFromPacket(message.summonType, message.subpsecies, message.behaviour);
            });
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        SummonSet summonSet = playerExt.getSummonSet(message.summonSetID);
        summonSet.readFromPacket(message.summonType, message.subpsecies, message.behaviour);
    }

    public static MessageSummonSet decode(PacketBuffer packet) {
        MessageSummonSet message = new MessageSummonSet();
        message.summonSetID = packet.readByte();
        message.summonType = packet.func_150789_c(256);
        message.subpsecies = packet.readInt();
        message.behaviour = packet.readByte();
        return message;
    }

    public static void encode(MessageSummonSet message, PacketBuffer packet) {
        packet.writeByte((int)message.summonSetID);
        packet.func_180714_a(message.summonType);
        packet.writeInt(message.subpsecies);
        packet.writeByte((int)message.behaviour);
    }
}

