/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSpawnEntity {
    public String entityTypeName = "";
    public int entityId = 0;
    public UUID uuid;
    public float pitch;
    public float yaw;
    public double x;
    public double y;
    public double z;

    public MessageSpawnEntity() {
    }

    public MessageSpawnEntity(Entity serverEntity) {
        if (serverEntity != null) {
            if (serverEntity instanceof BaseProjectileEntity) {
                this.entityTypeName = ((BaseProjectileEntity)serverEntity).entityName;
            }
            this.entityId = serverEntity.func_145782_y();
            this.uuid = serverEntity.func_110124_au();
            this.pitch = serverEntity.field_70125_A;
            this.yaw = serverEntity.field_70177_z;
            this.x = serverEntity.func_213303_ch().func_82615_a();
            this.y = serverEntity.func_213303_ch().func_82617_b();
            this.z = serverEntity.func_213303_ch().func_82616_c();
        }
    }

    public static void handle(MessageSpawnEntity message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            if (!EntityFactory.getInstance().entityTypeNetworkMap.containsKey(message.entityTypeName)) {
                LycanitesMobs.logWarning("", "Unable to find entity type from packet: " + message.entityTypeName);
                return;
            }
            EntityType entityType = EntityFactory.getInstance().entityTypeNetworkMap.get(message.entityTypeName);
            Entity entity = EntityFactory.getInstance().create(entityType, LycanitesMobs.PROXY.getWorld());
            if (entity == null) {
                LycanitesMobs.logWarning("", "Unable to create client entity from packet: " + message.entityTypeName);
                return;
            }
            entity.func_70107_b(message.x, message.y, message.z);
            entity.field_70125_A = message.pitch;
            entity.field_70177_z = message.yaw;
            entity.func_145769_d(message.entityId);
            entity.func_184221_a(message.uuid);
            if (entity instanceof BaseProjectileEntity) {
                ProjectileInfo projectileInfo;
                BaseProjectileEntity projectileEntity = (BaseProjectileEntity)entity;
                projectileEntity.entityName = message.entityTypeName;
                if (entity instanceof CustomProjectileEntity && (projectileInfo = ProjectileManager.getInstance().getProjectile(message.entityTypeName)) != null) {
                    ((CustomProjectileEntity)entity).setProjectileInfo(projectileInfo);
                }
            }
            LycanitesMobs.PROXY.addEntityToWorld(message.entityId, entity);
        });
    }

    public static MessageSpawnEntity decode(PacketBuffer packet) {
        MessageSpawnEntity message = new MessageSpawnEntity();
        message.entityTypeName = packet.func_218666_n();
        message.entityId = packet.readInt();
        message.uuid = packet.func_179253_g();
        message.pitch = packet.readFloat();
        message.yaw = packet.readFloat();
        message.x = packet.readDouble();
        message.y = packet.readDouble();
        message.z = packet.readDouble();
        return message;
    }

    public static void encode(MessageSpawnEntity message, PacketBuffer packet) {
        packet.func_180714_a(message.entityTypeName);
        packet.writeInt(message.entityId);
        packet.func_179252_a(message.uuid);
        packet.writeFloat(message.pitch);
        packet.writeFloat(message.yaw);
        packet.writeDouble(message.x);
        packet.writeDouble(message.y);
        packet.writeDouble(message.z);
    }
}

