/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.entity.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerAttack {
    public int attackEntityID = 0;

    public MessagePlayerAttack() {
    }

    public MessagePlayerAttack(Entity attackEntity) {
        if (attackEntity != null) {
            this.attackEntityID = attackEntity.func_145782_y();
        }
    }

    public static void handle(MessagePlayerAttack message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
            if (message.attackEntityID != 0) {
                playerExt.meleeAttack(player.func_130014_f_().func_73045_a(message.attackEntityID));
            }
        });
    }

    public static MessagePlayerAttack decode(PacketBuffer packet) {
        MessagePlayerAttack message = new MessagePlayerAttack();
        message.attackEntityID = packet.readInt();
        return message;
    }

    public static void encode(MessagePlayerAttack message, PacketBuffer packet) {
        packet.writeInt(message.attackEntityID);
    }
}

