/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.entity.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageGUIRequest {
    public byte guiId;

    public MessageGUIRequest() {
    }

    public MessageGUIRequest(GuiRequest guiRequest) {
        this.guiId = guiRequest.id;
    }

    public static void handle(MessageGUIRequest message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
            if (message.guiId == GuiRequest.BEASTIARY.id) {
                playerExt.onOpenBeastiary();
            }
        });
    }

    public static MessageGUIRequest decode(PacketBuffer packet) {
        MessageGUIRequest message = new MessageGUIRequest();
        message.guiId = packet.readByte();
        return message;
    }

    public static void encode(MessageGUIRequest message, PacketBuffer packet) {
        packet.writeByte((int)message.guiId);
    }

    public static enum GuiRequest {
        BEASTIARY(0);

        public byte id;

        private GuiRequest(byte i) {
            this.id = i;
        }
    }
}

