/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityPerched {
    public int perchedOnEntityID;
    public int perchedByEntityID;

    public MessageEntityPerched() {
    }

    public MessageEntityPerched(Entity perchedOnEntityID, Entity perchedByEntity) {
        this.perchedOnEntityID = perchedOnEntityID.func_145782_y();
        this.perchedByEntityID = perchedByEntity != null ? perchedByEntity.func_145782_y() : 0;
    }

    public static void handle(MessageEntityPerched message, Supplier<NetworkEvent.Context> ctx) {
        Entity perchedByEntity;
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        World world = player.func_130014_f_();
        Entity perchedOnEntity = world.func_73045_a(message.perchedOnEntityID);
        Entity entity = perchedByEntity = message.perchedByEntityID != 0 ? world.func_73045_a(message.perchedByEntityID) : null;
        if (!(perchedOnEntity instanceof LivingEntity)) {
            return;
        }
        ExtendedEntity perchedOnEntityExt = ExtendedEntity.getForEntity((LivingEntity)perchedOnEntity);
        if (perchedOnEntityExt != null) {
            perchedOnEntityExt.setPerchedByEntity(perchedByEntity);
        }
    }

    public static MessageEntityPerched decode(PacketBuffer packet) {
        MessageEntityPerched message = new MessageEntityPerched();
        message.perchedOnEntityID = packet.readInt();
        message.perchedByEntityID = packet.readInt();
        return message;
    }

    public static void encode(MessageEntityPerched message, PacketBuffer packet) {
        packet.writeInt(message.perchedOnEntityID);
        packet.writeInt(message.perchedByEntityID);
    }
}

