/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;

public class EntitySpawnPacket
implements IPacket<ClientPlayNetHandler> {
    public String entityTypeName = "";
    public int entityId = 0;
    public UUID uuid;
    public float pitch;
    public float yaw;
    public Vec3d pos;
    public double y;
    public double z;

    public EntitySpawnPacket(Entity serverEntity) {
        if (serverEntity != null) {
            if (serverEntity instanceof BaseProjectileEntity) {
                this.entityTypeName = ((BaseProjectileEntity)serverEntity).entityName;
            }
            this.entityId = serverEntity.func_145782_y();
            this.uuid = serverEntity.func_110124_au();
            this.pitch = serverEntity.field_70125_A;
            this.yaw = serverEntity.field_70177_z;
            this.pos = serverEntity.func_213303_ch();
        }
    }

    public void func_148837_a(PacketBuffer packet) throws IOException {
        this.entityTypeName = packet.func_218666_n();
        this.entityId = packet.readInt();
        this.uuid = packet.func_179253_g();
        this.pitch = packet.readFloat();
        this.yaw = packet.readFloat();
        this.pos = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
    }

    public void func_148840_b(PacketBuffer packet) throws IOException {
        packet.func_180714_a(this.entityTypeName);
        packet.writeInt(this.entityId);
        packet.func_179252_a(this.uuid);
        packet.writeFloat(this.pitch);
        packet.writeFloat(this.yaw);
        packet.writeDouble(this.pos.func_82615_a());
        packet.writeDouble(this.pos.func_82617_b());
        packet.writeDouble(this.pos.func_82616_c());
    }

    public void processPacket(ClientPlayNetHandler handler) {
        if (!EntityFactory.getInstance().entityTypeNetworkMap.containsKey(this.entityTypeName)) {
            LycanitesMobs.logWarning("", "Unable to find entity type from packet: " + this.entityTypeName);
            return;
        }
        EntityType entityType = EntityFactory.getInstance().entityTypeNetworkMap.get(this.entityTypeName);
        Entity entity = EntityFactory.getInstance().create(entityType, LycanitesMobs.PROXY.getWorld());
        if (entity == null) {
            LycanitesMobs.logWarning("", "Unable to create client entity from packet: " + this.entityTypeName);
            return;
        }
        entity.func_70107_b(this.pos.func_82615_a(), this.pos.func_82617_b(), this.pos.func_82616_c());
        entity.field_70125_A = this.pitch;
        entity.field_70177_z = this.yaw;
        entity.func_145769_d(this.entityId);
        entity.func_184221_a(this.uuid);
        if (entity instanceof BaseProjectileEntity) {
            ProjectileInfo projectileInfo;
            ((BaseProjectileEntity)entity).entityName = this.entityTypeName;
            if (entity instanceof CustomProjectileEntity && (projectileInfo = ProjectileManager.getInstance().getProjectile(this.entityTypeName)) != null) {
                ((CustomProjectileEntity)entity).setProjectileInfo(projectileInfo);
            }
        }
        handler.func_195514_j().func_217411_a(this.entityId, entity);
    }
}

