/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent.effects;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.mobevent.effects.CommandMobEventEffect;
import com.lycanitesmobs.core.mobevent.effects.StructureMobEventEffect;
import com.lycanitesmobs.core.mobevent.effects.WorldMobEventEffect;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MobEventEffect {
    public double eventTicksMin = 0.0;
    public double eventTicksMax = 0.0;
    public double eventTicksN = 0.0;

    public static MobEventEffect createFromJSON(JsonObject json) {
        String type = json.get("type").getAsString();
        MobEventEffect mobEventEffect = null;
        if ("world".equalsIgnoreCase(type)) {
            mobEventEffect = new WorldMobEventEffect();
        } else if ("structure".equalsIgnoreCase(type)) {
            mobEventEffect = new StructureMobEventEffect();
        } else if ("command".equalsIgnoreCase(type)) {
            mobEventEffect = new CommandMobEventEffect();
        }
        ((MobEventEffect)mobEventEffect).loadFromJSON(json);
        return mobEventEffect;
    }

    public void loadFromJSON(JsonObject json) {
        if (json.has("eventTicksMin")) {
            this.eventTicksMin = json.get("eventTicksMin").getAsDouble();
        }
        if (json.has("eventTicksMax")) {
            this.eventTicksMax = json.get("eventTicksMax").getAsDouble();
        }
        if (json.has("eventTicksN")) {
            this.eventTicksN = json.get("eventTicksN").getAsDouble();
        }
    }

    public boolean canActivate(World world, PlayerEntity player, BlockPos pos, int level, int ticks) {
        if (this.eventTicksMin >= 0.0 && (double)ticks < this.eventTicksMin) {
            return false;
        }
        if (this.eventTicksMax >= 0.0 && (double)ticks > this.eventTicksMax) {
            return false;
        }
        return !(this.eventTicksN >= 0.0) || (double)ticks % this.eventTicksN == 0.0;
    }

    public void onUpdate(World world, PlayerEntity player, BlockPos pos, int level, int ticks) {
    }

    public void onSpawn(LivingEntity entity, World world, PlayerEntity player, BlockPos pos, int level, int ticks) {
    }
}

