/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.config.ConfigMobEvent;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.MobEventSchedule;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobEventManager
extends JSONLoader {
    protected static MobEventManager INSTANCE;
    public Map<String, MobEvent> mobEvents = new HashMap<String, MobEvent>();
    public List<MobEventSchedule> mobEventSchedules = new ArrayList<MobEventSchedule>();
    public List<SpawnCondition> globalEventConditions = new ArrayList<SpawnCondition>();
    public boolean mobEventsEnabled = true;
    public boolean mobEventsRandom = false;
    public int defaultMobDuration = 12000;
    public int minEventsRandomDay = 0;
    public int minTicksUntilEvent = 72000;
    public int maxTicksUntilEvent = 144000;

    public static MobEventManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobEventManager();
        }
        return INSTANCE;
    }

    public void loadConfig() {
        LycanitesMobs.logDebug("", "Config Test: " + ConfigMobEvent.INSTANCE.mobEventsEnabled.get());
        this.mobEventsEnabled = (Boolean)ConfigMobEvent.INSTANCE.mobEventsEnabled.get();
        this.mobEventsRandom = (Boolean)ConfigMobEvent.INSTANCE.mobEventsRandom.get();
        this.defaultMobDuration = (Integer)ConfigMobEvent.INSTANCE.defaultMobDuration.get();
        this.minEventsRandomDay = (Integer)ConfigMobEvent.INSTANCE.minEventsRandomDay.get();
        this.minTicksUntilEvent = (Integer)ConfigMobEvent.INSTANCE.minTicksUntilEvent.get();
        this.maxTicksUntilEvent = (Integer)ConfigMobEvent.INSTANCE.maxTicksUntilEvent.get();
    }

    public void loadAllFromJson(ModInfo groupInfo) {
        try {
            this.loadAllJson(groupInfo, "Mob Event", "mobevents", "name", true, "event", FileLoader.COMMON, StreamLoader.COMMON);
            LycanitesMobs.logDebug("MobEvents", "Complete! " + this.mobEvents.size() + " JSON Mob Events Loaded In Total.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadGlobalEventConditions();
        this.loadScheduledEvents();
    }

    public void loadGlobalEventConditions() {
        JsonObject globalJson;
        JsonObject defaultGlobalJson;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String configPath = new File(".") + "/config/" + "lycanitesmobs" + "/";
        this.globalEventConditions.clear();
        if (FileLoader.SERVER.ready) {
            Path defaultGlobalPath = FileLoader.SERVER.getPath("globalmobevent.json");
            LycanitesMobs.logDebug("", "Global Spawner JSON Path:" + defaultGlobalPath);
            defaultGlobalJson = this.loadJsonObject(gson, defaultGlobalPath);
        } else {
            defaultGlobalJson = this.loadJsonObject(gson, StreamLoader.SERVER.getStream("globalmobevent.json"));
        }
        if (defaultGlobalJson == null) {
            LycanitesMobs.logWarning("", "Could not find Global Mob Event JSON.");
        }
        File customGlobalFile = new File(configPath + "globalmobevent.json");
        JsonObject customGlobalJson = null;
        if (customGlobalFile.exists()) {
            customGlobalJson = this.loadJsonObject(gson, customGlobalFile.toPath());
        }
        if ((globalJson = this.writeDefaultJSONObject(gson, "globalmobevent", defaultGlobalJson, customGlobalJson)).has("conditions")) {
            JsonArray jsonArray = globalJson.get("conditions").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject spawnConditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(spawnConditionJson);
                this.globalEventConditions.add(spawnCondition);
            }
        }
        if (this.globalEventConditions.size() > 0) {
            LycanitesMobs.logDebug("JSONSpawner", "Loaded " + this.globalEventConditions.size() + " Global Mob Event Conditions.");
        }
    }

    public void loadScheduledEvents() {
        JsonObject scheduleJson;
        JsonObject defaultScheduleJson;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String configPath = new File(".") + "/config/" + "lycanitesmobs" + "/";
        this.mobEventSchedules.clear();
        if (FileLoader.SERVER.ready) {
            Path defaultSchedulePath = FileLoader.SERVER.getPath("mobeventschedule.json");
            defaultScheduleJson = this.loadJsonObject(gson, defaultSchedulePath);
        } else {
            defaultScheduleJson = this.loadJsonObject(gson, StreamLoader.SERVER.getStream("mobeventschedule.json"));
        }
        File customScheduleFile = new File(configPath + "mobeventschedule.json");
        JsonObject customScheduleJson = null;
        if (customScheduleFile.exists()) {
            customScheduleJson = this.loadJsonObject(gson, customScheduleFile.toPath());
        }
        if ((scheduleJson = this.writeDefaultJSONObject(gson, "mobeventschedule", defaultScheduleJson, customScheduleJson)).has("schedules")) {
            JsonArray jsonArray = scheduleJson.get("schedules").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject scheduleEntryJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                MobEventSchedule mobEventSchedule = MobEventSchedule.createFromJSON(scheduleEntryJson);
                this.mobEventSchedules.add(mobEventSchedule);
            }
        }
        if (this.mobEventSchedules.size() > 0) {
            LycanitesMobs.logDebug("MobEvents", "Loaded " + this.mobEventSchedules.size() + " Mob Event Schedules.");
        }
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        LycanitesMobs.logDebug("MobEvents", "Loading Mob Event JSON: " + json);
        MobEvent mobEvent = new MobEvent();
        mobEvent.loadFromJSON(json);
        this.addMobEvent(mobEvent);
    }

    public void reload() {
        LycanitesMobs.logDebug("MobEvents", "Destroying JSON Mob Events!");
        for (MobEvent mobEvent : this.mobEvents.values().toArray(new MobEvent[this.mobEvents.size()])) {
            mobEvent.destroy();
        }
        this.loadAllFromJson(LycanitesMobs.modInfo);
    }

    public void addMobEvent(MobEvent mobEvent) {
        if (mobEvent == null) {
            return;
        }
        this.mobEvents.put(mobEvent.name, mobEvent);
        try {
            ObjectManager.addSound("mobevent_" + mobEvent.title.toLowerCase(), LycanitesMobs.modInfo, "mobevent." + mobEvent.title.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeMobEvent(MobEvent mobEvent) {
        if (!this.mobEvents.containsKey(mobEvent.name)) {
            LycanitesMobs.logWarning("", "[MobEvents] Tried to remove a Mob Event that hasn't been added: " + mobEvent.name);
            return;
        }
        this.mobEvents.remove(mobEvent.name);
    }

    public MobEvent getMobEvent(String mobEventName) {
        if (!this.mobEvents.containsKey(mobEventName)) {
            return null;
        }
        return this.mobEvents.get(mobEventName);
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        if (worldExt.lastEventUpdateTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastEventUpdateTime = world.func_82737_E();
        if (world.func_217369_A().size() < 1) {
            return;
        }
        if (worldExt.serverWorldEventPlayer != null) {
            worldExt.serverWorldEventPlayer.onUpdate();
        }
        if (worldExt.serverMobEventPlayers.size() > 0) {
            for (MobEventPlayerServer mobEventPlayerServer : worldExt.serverMobEventPlayers.values().toArray(new MobEventPlayerServer[worldExt.serverMobEventPlayers.size()])) {
                mobEventPlayerServer.onUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (ClientManager.getInstance().getClientPlayer() == null) {
            return;
        }
        World world = ClientManager.getInstance().getClientPlayer().func_130014_f_();
        if (!world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        for (MobEventPlayerClient mobEventPlayerClient : worldExt.clientMobEventPlayers.values()) {
            mobEventPlayerClient.onUpdate();
        }
        if (worldExt.clientWorldEventPlayer != null) {
            worldExt.clientWorldEventPlayer.onUpdate();
        }
    }
}

