/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.summoningstaff;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.PortalEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.BaseItem;
import com.lycanitesmobs.core.pets.SummonSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStaffSummoning
extends BaseItem {
    protected float damageScale = 1.0f;
    protected int weaponFlash = 0;

    public ItemStaffSummoning(Item.Properties properties, String itemName, String textureName) {
        super(properties);
        this.itemName = itemName;
        this.setup();
        this.func_185043_a(new ResourceLocation("using"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack itemStack, World world, LivingEntity entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f;
            }
        });
    }

    public void damageItemCharged(ItemStack itemStack, LivingEntity entity, float power) {
        ExtendedPlayer playerExt = null;
        if (entity instanceof PlayerEntity) {
            playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)entity);
        }
        if (playerExt != null && playerExt.staffPortal != null) {
            this.damage_item(itemStack, playerExt.staffPortal.summonAmount, (ServerPlayerEntity)entity);
        }
    }

    public boolean onEntitySwing(ItemStack itemStack, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            entity.func_184598_c(Hand.MAIN_HAND);
            return true;
        }
        return super.onEntitySwing(itemStack, entity);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemStack, PlayerEntity player, Entity entity) {
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt != null) {
            SummonSet summonSet = playerExt.getSelectedSummonSet();
            if (summonSet.isUseable()) {
                if (!player.func_130014_f_().field_72995_K) {
                    playerExt.staffPortal = new PortalEntity(ProjectileManager.getInstance().oldProjectileTypes.get(PortalEntity.class), world, player, summonSet.getCreatureType(), this);
                    playerExt.staffPortal.func_70012_b(player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    world.func_217376_c((Entity)playerExt.staffPortal);
                }
            } else {
                playerExt.staffPortal = null;
                if (!player.func_130014_f_().func_201670_d()) {
                    playerExt.sendAllSummonSetsToPlayer();
                } else {
                    ClientManager.getInstance().displayGuiScreen("beastiary", player);
                }
            }
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void onUsingTick(ItemStack itemStack, LivingEntity entity, int useRemaining) {
        int rapidRemainder;
        if (itemStack == null || entity == null) {
            return;
        }
        int useTime = this.func_77626_a(itemStack) - useRemaining;
        if (useTime >= this.getRapidTime(itemStack) && (rapidRemainder = useTime % this.getRapidTime(itemStack)) == 0 && this.rapidAttack(itemStack, entity.func_130014_f_(), entity)) {
            this.weaponFlash = Math.max(20, this.getRapidTime(itemStack));
        }
        if (useTime >= this.getChargeTime(itemStack)) {
            this.weaponFlash = Math.max(20, this.getChargeTime(itemStack));
        }
        super.onUsingTick(itemStack, entity, useRemaining);
    }

    @Override
    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int useTime = this.func_77626_a(stack) - timeLeft;
        float power = (float)useTime / (float)this.getChargeTime(stack);
        this.weaponFlash = 0;
        if ((double)power < 0.1) {
            return;
        }
        if (power > 1.0f) {
            power = 1.0f;
        }
        if (this.chargedAttack(stack, worldIn, entityLiving, power)) {
            this.damageItemCharged(stack, entityLiving, power);
            this.weaponFlash = Math.min(20, this.getChargeTime(stack));
        }
        ExtendedPlayer playerExt = null;
        if (entityLiving instanceof PlayerEntity) {
            playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)entityLiving);
        }
        if (playerExt != null) {
            playerExt.staffPortal = null;
        }
    }

    @Override
    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public int getChargeTime(ItemStack itemStack) {
        return 1;
    }

    public int getRapidTime(ItemStack itemStack) {
        return 20;
    }

    public int getSummonCostBoost() {
        return 0;
    }

    public float getSummonCostMod() {
        return 1.0f;
    }

    public int getSummonDuration() {
        return 1200;
    }

    public int getSummonAmount() {
        return 1;
    }

    public boolean getAdditionalCosts(PlayerEntity player) {
        return true;
    }

    public void applyMinionBehaviour(TameableCreatureEntity minion, PlayerEntity player) {
        SummonSet summonSet = ExtendedPlayer.getForPlayer(player).getSelectedSummonSet();
        summonSet.applyBehaviour(minion);
        minion.applySubspecies(summonSet.subspecies);
    }

    public void applyMinionEffects(BaseCreatureEntity minion) {
    }

    public boolean rapidAttack(ItemStack itemStack, World world, LivingEntity entity) {
        return false;
    }

    protected void damage_item(ItemStack itemStack, int amountToDamage, ServerPlayerEntity entity) {
        itemStack.func_96631_a(amountToDamage, entity.func_70681_au(), entity);
        if (itemStack.func_190916_E() == 0) {
            if (entity.func_184586_b(Hand.MAIN_HAND).equals(itemStack)) {
                entity.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            } else if (entity.func_184586_b(Hand.OFF_HAND).equals(itemStack)) {
                entity.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            }
        }
    }

    public boolean chargedAttack(ItemStack itemStack, World world, LivingEntity entity, float power) {
        ExtendedPlayer playerExt = null;
        if (entity instanceof PlayerEntity) {
            playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)entity);
        }
        if (playerExt != null && playerExt.staffPortal != null) {
            int successCount = playerExt.staffPortal.summonCreatures();
            this.damage_item(itemStack, successCount, (ServerPlayerEntity)entity);
            return successCount > 0;
        }
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        if (repairStack.func_77973_b() == Items.field_151043_k) {
            return true;
        }
        return super.func_82789_a(itemStack, repairStack);
    }
}

