/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SummonEquipmentFeature
extends EquipmentFeature {
    public String summonMobId;
    public double summonChance = 0.05;
    public int summonDuration = 60;
    public int summonCountMin = 1;
    public int summonCountMax = 1;
    public double sizeScale = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.summonMobId = json.get("summonMobId").getAsString();
        if (json.has("summonChance")) {
            this.summonChance = json.get("summonChance").getAsDouble();
        }
        if (json.has("summonDuration")) {
            this.summonDuration = json.get("summonDuration").getAsInt();
        }
        if (json.has("summonCountMin")) {
            this.summonCountMin = json.get("summonCountMin").getAsInt();
        }
        if (json.has("summonCountMax")) {
            this.summonCountMax = json.get("summonCountMax").getAsInt();
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent description = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("entity." + this.summonMobId + ".name", new Object[0])).func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.summon.chance", new Object[0])).func_150258_a(" " + Math.round(this.summonChance * 100.0) + "%");
        if (this.summonDuration > 0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.effect.duration", new Object[0])).func_150258_a(" " + (float)this.summonDuration / 20.0f);
        }
        if (this.summonCountMin != this.summonCountMax) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.summon.count", new Object[0])).func_150258_a(" " + this.summonCountMin + " - " + this.summonCountMax);
        } else {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.summon.count", new Object[0])).func_150258_a(" " + this.summonCountMax);
        }
        return description;
    }

    @Override
    public ITextComponent getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        return new TranslationTextComponent("entity." + this.summonMobId + ".name", new Object[0]);
    }

    public void onHitEntity(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (target == null || attacker == null || attacker.func_130014_f_().field_72995_K) {
            return;
        }
        EntityType entityType = null;
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreatureFromId(this.summonMobId);
        if (creatureInfo != null) {
            entityType = creatureInfo.getEntityType();
        } else {
            IForgeRegistryEntry entityTypeObj = GameRegistry.findRegistry(EntityType.class).getValue(new ResourceLocation(this.summonMobId));
            if (entityTypeObj instanceof EntityType) {
                entityType = (EntityType)entityTypeObj;
            }
        }
        if (entityType == null) {
            return;
        }
        int summonCount = this.summonCountMin;
        if (this.summonCountMax > this.summonCountMin) {
            summonCount = this.summonCountMin + attacker.func_70681_au().nextInt(this.summonCountMax - this.summonCountMin);
        }
        for (int i = 0; i < summonCount; ++i) {
            if (!(attacker.func_70681_au().nextDouble() <= this.summonChance)) continue;
            try {
                Entity entity = entityType.func_200721_a(attacker.func_130014_f_());
                entity.func_70012_b((double)attacker.func_180425_c().func_177958_n(), (double)attacker.func_180425_c().func_177956_o(), (double)attacker.func_180425_c().func_177952_p(), attacker.field_70177_z, 0.0f);
                if (!(entity instanceof BaseCreatureEntity)) continue;
                BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
                entityCreature.setMinion(true);
                entityCreature.setTemporary(this.summonDuration * 20);
                entityCreature.setSizeScale(this.sizeScale);
                if (attacker instanceof PlayerEntity && entityCreature instanceof TameableCreatureEntity) {
                    TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                    entityTameable.setPlayerOwner((PlayerEntity)attacker);
                    entityTameable.setSitting(false);
                    entityTameable.setFollowing(true);
                    entityTameable.setPassive(false);
                    entityTameable.setAssist(true);
                    entityTameable.setAggressive(true);
                    entityTameable.setPVP(target instanceof PlayerEntity);
                }
                float randomAngle = 45.0f + 45.0f * attacker.func_70681_au().nextFloat();
                if (attacker.func_70681_au().nextBoolean()) {
                    randomAngle = -randomAngle;
                }
                BlockPos spawnPos = entityCreature.getFacingPosition((Entity)attacker, -1.0, randomAngle);
                entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), attacker.field_70177_z, 0.0f);
                entityCreature.func_70624_b(target);
                entity.func_130014_f_().func_217376_c(entity);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

