/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ProjectileEquipmentFeature
extends EquipmentFeature {
    public String projectileName;
    public String projectileTrigger = "secondary";
    public String projectilePattern = "simple";
    public double hitChance = 0.05;
    public int cooldown = 2;
    public int count = 1;
    public double spreadX = 0.0;
    public double spreadY = 0.0;
    public double ringRange = 0.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.projectileName = json.get("projectileName").getAsString();
        if (json.has("projectileTrigger")) {
            this.projectileTrigger = json.get("projectileTrigger").getAsString();
        }
        if (json.has("projectilePattern")) {
            this.projectilePattern = json.get("projectilePattern").getAsString();
        }
        if (json.has("hitChance")) {
            this.hitChance = json.get("hitChance").getAsDouble();
        }
        if (json.has("cooldown")) {
            this.cooldown = json.get("cooldown").getAsInt();
        }
        if (json.has("count")) {
            this.count = json.get("count").getAsInt();
        }
        if (json.has("spreadX")) {
            this.spreadX = json.get("spreadX").getAsDouble();
        }
        if (json.has("spreadY")) {
            this.spreadY = json.get("spreadY").getAsDouble();
        }
        if (json.has("ringRange")) {
            this.ringRange = json.get("ringRange").getAsDouble();
        }
    }

    @Override
    public boolean isActive(ItemStack itemStack, int level) {
        if (!super.isActive(itemStack, level)) {
            return false;
        }
        return ProjectileManager.getInstance().getProjectile(this.projectileName) != null;
    }

    @Override
    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
        ITextComponent description = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" ").func_150257_a(projectileInfo.getTitle());
        description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.projectile.trigger", new Object[0])).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.projectile.trigger." + this.projectileTrigger, new Object[0]));
        if ("hit".equals(this.projectileTrigger)) {
            description.func_150258_a(" " + this.hitChance * 100.0 + "%");
        }
        if (!"simple".equals(this.projectilePattern)) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.projectile.pattern", new Object[0])).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.projectile.pattern.", new Object[0])).func_150258_a(this.projectilePattern);
        }
        return description;
    }

    @Override
    public ITextComponent getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
        return projectileInfo.getTitle();
    }

    public boolean onUseSecondary(World world, PlayerEntity shooter, Hand hand) {
        return true;
    }

    public void onHoldSecondary(LivingEntity shooter, int count) {
        if (!"secondary".equalsIgnoreCase(this.projectileTrigger)) {
            return;
        }
        ExtendedEntity shooterExt = ExtendedEntity.getForEntity(shooter);
        if (shooterExt == null) {
            return;
        }
        if (shooterExt.equipmentProjectileCooldown > 0) {
            return;
        }
        shooterExt.equipmentProjectileCooldown = this.cooldown;
        this.fireProjectile(shooter);
    }

    public void onHitEntity(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (target == null || attacker == null || attacker.func_130014_f_().field_72995_K || !"hit".equals(this.projectileTrigger)) {
            return;
        }
        if (attacker.func_70681_au().nextDouble() <= this.hitChance) {
            this.fireProjectile(attacker);
        }
    }

    public void fireProjectile(LivingEntity shooter) {
        if (shooter == null || shooter.func_130014_f_().field_72995_K) {
            return;
        }
        World world = shooter.func_130014_f_();
        BaseProjectileEntity mainProjectile = null;
        Vec3d firePos = new Vec3d(shooter.func_213303_ch().func_82615_a(), shooter.func_213303_ch().func_82617_b() + (double)shooter.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.65, shooter.func_213303_ch().func_82616_c());
        double offsetX = 0.0;
        if ("spread".equals(this.projectilePattern)) {
            this.count = 10;
            this.spreadX = 45.0;
            this.spreadY = 10.0;
            for (int i = 0; i < this.count; ++i) {
                double yaw = (double)shooter.field_70177_z + this.spreadX * shooter.func_70681_au().nextDouble() - this.spreadX / 2.0;
                double pitch = (double)shooter.field_70125_A + this.spreadY * shooter.func_70681_au().nextDouble() - this.spreadY / 2.0;
                ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
                BaseProjectileEntity projectile = projectileInfo.createProjectile(world, shooter);
                projectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
                projectile.func_184538_a((Entity)shooter, (float)pitch, (float)yaw - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
                world.func_217376_c((Entity)projectile);
                mainProjectile = projectile;
            }
        } else if ("ring".equals(this.projectilePattern)) {
            double angle = this.ringRange / (double)this.count;
            for (int i = 0; i < this.count; ++i) {
                double yaw = (double)shooter.field_70177_z + angle * (double)i - this.ringRange / 2.0;
                ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
                BaseProjectileEntity projectile = projectileInfo.createProjectile(world, shooter);
                projectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
                world.func_217376_c((Entity)projectile);
                projectile.func_184538_a((Entity)shooter, shooter.field_70125_A, (float)yaw - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
                mainProjectile = projectile;
            }
        } else {
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
            mainProjectile = projectileInfo.createProjectile(world, shooter);
            mainProjectile.func_70107_b(firePos.field_72450_a, firePos.field_72448_b, firePos.field_72449_c);
            mainProjectile.func_184538_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z - (float)offsetX, 0.0f, (float)projectileInfo.velocity, 0.0f);
            world.func_217376_c((Entity)mainProjectile);
        }
        if (shooter instanceof PlayerEntity && mainProjectile != null) {
            world.func_184133_a(null, shooter.func_180425_c(), mainProjectile.getLaunchSound(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public Vec3d getFacingPosition(LivingEntity entity, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new Vec3d(entity.func_213303_ch().func_82615_a() + distance * xAmount, entity.func_213303_ch().func_82617_b(), entity.func_213303_ch().func_82616_c() + distance * zAmount);
    }
}

