/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class HarvestEquipmentFeature
extends EquipmentFeature {
    private static final Set<Block> SPADE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196874_iZ});
    private static final Set<Block> PICKAXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final Set<Block> AXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_196662_n, Blocks.field_150342_X, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_196689_eF, Blocks.field_196663_cq});
    public String harvestType;
    public String harvestShape = "block";
    public float harvestSpeed = 1.0f;
    public int harvestLevel = 3;
    public Vec3i harvestRange = new Vec3i(0, 0, 0);
    public double harvestRangeLevelMultiplier = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.harvestType = json.get("harvestType").getAsString();
        if (json.has("harvestType")) {
            this.harvestType = json.get("harvestType").getAsString();
        }
        if (json.has("harvestSpeed")) {
            this.harvestSpeed = json.get("harvestSpeed").getAsFloat();
        }
        if (json.has("harvestLevel")) {
            this.harvestLevel = json.get("harvestLevel").getAsInt();
        }
        if (json.has("harvestShape")) {
            this.harvestShape = json.get("harvestShape").getAsString();
        }
        this.harvestRange = JSONHelper.getVec3i(json, "harvestRange");
        if (json.has("harvestRangeLevelMultiplier")) {
            this.harvestRangeLevelMultiplier = json.get("harvestRangeLevelMultiplier").getAsDouble();
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent description = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" " + this.harvestType);
        description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.harvest.shape", new Object[0])).func_150258_a(" " + this.harvestShape);
        Vec3i vec3i = new Vec3i(0, 0, 0);
        if (this.harvestRange.func_177951_i(vec3i) > 0.0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.harvest.range", new Object[0])).func_150258_a(" " + this.getHarvestRangeString(level));
        }
        return description;
    }

    @Override
    public ITextComponent getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent summary = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" " + this.harvestType);
        summary.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.harvest.shape", new Object[0])).func_150258_a(" " + this.harvestShape);
        Vec3i vec3i = new Vec3i(0, 0, 0);
        if (this.harvestRange.func_177951_i(vec3i) > 0.0) {
            summary.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.harvest.range", new Object[0])).func_150258_a(" " + this.getHarvestRangeString(level));
        }
        return summary;
    }

    public String getHarvestRangeString(int level) {
        String harvestRangeString = "" + Math.round((double)this.harvestRange.func_177958_n() + (double)(this.harvestRange.func_177958_n() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + "x" + Math.round((double)this.harvestRange.func_177956_o() + (double)(this.harvestRange.func_177956_o() * (level - 1)) * this.harvestRangeLevelMultiplier);
        harvestRangeString = harvestRangeString + "x" + Math.round((double)this.harvestRange.func_177952_p() + (double)(this.harvestRange.func_177952_p() * (level - 1)) * this.harvestRangeLevelMultiplier);
        return harvestRangeString;
    }

    @Nullable
    public ToolType getToolType() {
        return ToolType.get((String)this.harvestType);
    }

    public boolean canHarvestBlock(BlockState blockState) {
        Block block = blockState.func_177230_c();
        Material material = blockState.func_185904_a();
        if (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e || PICKAXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("pickaxe");
        }
        if (material == Material.field_151575_d || AXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("axe");
        }
        if (material == Material.field_151585_k || material == Material.field_151582_l) {
            return this.harvestType.equalsIgnoreCase("axe") || this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151569_G || material == Material.field_151584_j || material == Material.field_204868_h) {
            return this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151578_c || material == Material.field_151571_B || material == Material.field_151595_p || material == Material.field_151577_b || SPADE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("shovel");
        }
        if (material == Material.field_151589_v || material == Material.field_151572_C) {
            return this.harvestType.equalsIgnoreCase("sword");
        }
        if (block == Blocks.field_150473_bD) {
            return this.harvestType.equalsIgnoreCase("shears");
        }
        return false;
    }

    public float getHarvestSpeed(BlockState blockState) {
        if (!this.canHarvestBlock(blockState)) {
            return 0.0f;
        }
        return this.harvestSpeed * this.getHarvestMultiplier(blockState);
    }

    public float getHarvestMultiplier(BlockState blockState) {
        Material material = blockState.func_185904_a();
        if (material == Material.field_151569_G) {
            return 10.0f;
        }
        if ((material == Material.field_151584_j || material == Material.field_151582_l) && this.harvestType.equalsIgnoreCase("shears")) {
            return 10.0f;
        }
        return 1.0f;
    }

    public void onBlockDestroyed(World world, BlockState harvestedBlockState, BlockPos harvestedPos, LivingEntity livingEntity) {
        if (livingEntity == null || livingEntity.func_225608_bj_()) {
            return;
        }
        Direction facingH = livingEntity.func_174811_aO();
        Direction facingLat = facingH.func_176746_e();
        Direction facing = facingH;
        if (livingEntity.field_70125_A > 45.0f) {
            facing = Direction.DOWN;
        } else if (livingEntity.field_70125_A < -45.0f) {
            facing = Direction.UP;
        }
        Vec3i[][] selectionRanges = new Vec3i[3][2];
        int lon = 0;
        int lat = 1;
        int vert = 2;
        int min = 0;
        int max = 1;
        selectionRanges[lon][min] = new Vec3i(Math.min(0, this.harvestRange.func_177952_p() * facing.func_82601_c()), Math.min(0, this.harvestRange.func_177952_p() * facing.func_96559_d()), Math.min(0, this.harvestRange.func_177952_p() * facing.func_82599_e()));
        selectionRanges[lon][max] = new Vec3i(Math.max(0, this.harvestRange.func_177952_p() * facing.func_82601_c()), Math.max(0, this.harvestRange.func_177952_p() * facing.func_96559_d()), Math.max(0, this.harvestRange.func_177952_p() * facing.func_82599_e()));
        selectionRanges[lat][min] = new Vec3i(this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_82601_c()), this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_96559_d()), this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_82599_e()));
        selectionRanges[lat][max] = new Vec3i(this.harvestRange.func_177958_n() * Math.abs(facingLat.func_82601_c()), this.harvestRange.func_177958_n() * Math.abs(facingLat.func_96559_d()), this.harvestRange.func_177958_n() * Math.abs(facingLat.func_82599_e()));
        if (facing != Direction.DOWN && facing != Direction.UP) {
            int vertOffset = this.harvestRange.func_177956_o() != 0 ? -1 : 0;
            selectionRanges[vert][min] = new Vec3i(0, vertOffset, 0);
            selectionRanges[vert][max] = new Vec3i(0, this.harvestRange.func_177956_o() + vertOffset, 0);
        } else {
            selectionRanges[vert][min] = new Vec3i(this.harvestRange.func_177956_o() * -Math.abs(facingH.func_82601_c()), this.harvestRange.func_177956_o() * -Math.abs(facingH.func_96559_d()), this.harvestRange.func_177956_o() * -Math.abs(facingH.func_82599_e()));
            selectionRanges[vert][max] = new Vec3i(this.harvestRange.func_177956_o() * Math.abs(facingH.func_82601_c()), this.harvestRange.func_177956_o() * Math.abs(facingH.func_96559_d()), this.harvestRange.func_177956_o() * Math.abs(facingH.func_82599_e()));
        }
        if (this.harvestShape.equalsIgnoreCase("block") || this.harvestShape.equalsIgnoreCase("random")) {
            boolean random = this.harvestShape.equalsIgnoreCase("random");
            for (int longX = selectionRanges[lon][min].func_177958_n(); longX <= selectionRanges[lon][max].func_177958_n(); ++longX) {
                for (int longY = selectionRanges[lon][min].func_177956_o(); longY <= selectionRanges[lon][max].func_177956_o(); ++longY) {
                    for (int longZ = selectionRanges[lon][min].func_177952_p(); longZ <= selectionRanges[lon][max].func_177952_p(); ++longZ) {
                        for (int latX = selectionRanges[lat][min].func_177958_n(); latX <= selectionRanges[lat][max].func_177958_n(); ++latX) {
                            for (int latY = selectionRanges[lat][min].func_177956_o(); latY <= selectionRanges[lat][max].func_177956_o(); ++latY) {
                                for (int latZ = selectionRanges[lat][min].func_177952_p(); latZ <= selectionRanges[lat][max].func_177952_p(); ++latZ) {
                                    for (int vertX = selectionRanges[vert][min].func_177958_n(); vertX <= selectionRanges[vert][max].func_177958_n(); ++vertX) {
                                        for (int vertY = selectionRanges[vert][min].func_177956_o(); vertY <= selectionRanges[vert][max].func_177956_o(); ++vertY) {
                                            for (int vertZ = selectionRanges[vert][min].func_177952_p(); vertZ <= selectionRanges[vert][max].func_177952_p(); ++vertZ) {
                                                BlockPos destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(latX, latY, latZ).func_177982_a(vertX, vertY, vertZ);
                                                if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos) || random && !world.field_73012_v.nextBoolean()) continue;
                                                world.func_175655_b(destroyPos, true);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return;
        }
        if (this.harvestShape.equalsIgnoreCase("cross")) {
            for (int longX = selectionRanges[lon][min].func_177958_n(); longX <= selectionRanges[lon][max].func_177958_n(); ++longX) {
                for (int longY = selectionRanges[lon][min].func_177956_o(); longY <= selectionRanges[lon][max].func_177956_o(); ++longY) {
                    for (int longZ = selectionRanges[lon][min].func_177952_p(); longZ <= selectionRanges[lon][max].func_177952_p(); ++longZ) {
                        BlockPos destroyPos;
                        for (int latX = selectionRanges[lat][min].func_177958_n(); latX <= selectionRanges[lat][max].func_177958_n(); ++latX) {
                            for (int latY = selectionRanges[lat][min].func_177956_o(); latY <= selectionRanges[lat][max].func_177956_o(); ++latY) {
                                for (int latZ = selectionRanges[lat][min].func_177952_p(); latZ <= selectionRanges[lat][max].func_177952_p(); ++latZ) {
                                    destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(latX, latY, latZ);
                                    if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos)) continue;
                                    world.func_175655_b(destroyPos, true);
                                }
                            }
                        }
                        for (int vertX = selectionRanges[vert][min].func_177958_n(); vertX <= selectionRanges[vert][max].func_177958_n(); ++vertX) {
                            for (int vertY = selectionRanges[vert][min].func_177956_o(); vertY <= selectionRanges[vert][max].func_177956_o(); ++vertY) {
                                for (int vertZ = selectionRanges[vert][min].func_177952_p(); vertZ <= selectionRanges[vert][max].func_177952_p(); ++vertZ) {
                                    destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(vertX, vertY, vertZ);
                                    if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos)) continue;
                                    world.func_175655_b(destroyPos, true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean shouldHarvestBlock(World world, BlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos) {
        if (harvestedPos.equals((Object)targetPos)) {
            return false;
        }
        BlockState targetBlockState = world.func_180495_p(targetPos);
        if (targetBlockState.func_177230_c() != harvestedBlockState.func_177230_c()) {
            return false;
        }
        return this.canHarvestBlock(world.func_180495_p(targetPos));
    }
}

