/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.DamageEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EffectEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.HarvestEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.ProjectileEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SlotEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SummonEquipmentFeature;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class EquipmentFeature {
    public String featureType;
    public int levelMin = -1;
    public int levelMax = -1;

    @Nullable
    public static EquipmentFeature createFromJSON(JsonObject json) {
        String type = json.get("featureType").getAsString();
        EquipmentFeature equipmentFeature = null;
        if ("slot".equalsIgnoreCase(type)) {
            equipmentFeature = new SlotEquipmentFeature();
        } else if ("harvest".equalsIgnoreCase(type)) {
            equipmentFeature = new HarvestEquipmentFeature();
        } else if ("damage".equalsIgnoreCase(type)) {
            equipmentFeature = new DamageEquipmentFeature();
        } else if ("effect".equalsIgnoreCase(type)) {
            equipmentFeature = new EffectEquipmentFeature();
        } else if ("summon".equalsIgnoreCase(type)) {
            equipmentFeature = new SummonEquipmentFeature();
        } else if ("projectile".equalsIgnoreCase(type)) {
            equipmentFeature = new ProjectileEquipmentFeature();
        }
        if (equipmentFeature == null) {
            return null;
        }
        equipmentFeature.featureType = type;
        ((EquipmentFeature)equipmentFeature).loadFromJSON(json);
        return equipmentFeature;
    }

    public void loadFromJSON(JsonObject json) {
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
    }

    public boolean isActive(ItemStack itemStack, int level) {
        if (this.levelMin > -1 && level < this.levelMin) {
            return false;
        }
        return this.levelMax <= -1 || level <= this.levelMax;
    }

    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        return new StringTextComponent("");
    }

    public ITextComponent getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        return new StringTextComponent(this.featureType);
    }
}

