/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EffectEquipmentFeature
extends EquipmentFeature {
    public String effectType;
    public String effectTarget;
    public int effectDuration = 0;
    public int effectStrength = 0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.effectType = json.get("effectType").getAsString();
        this.effectTarget = json.get("effectTarget").getAsString();
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectStrength")) {
            this.effectStrength = json.get("effectStrength").getAsInt();
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent description = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" ").func_150257_a(this.getEffectTypeName()).func_150258_a(" (" + this.effectTarget + ")");
        if (this.effectStrength > 0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.effect.strength", new Object[0])).func_150258_a(" " + this.effectStrength);
        }
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.effect.duration", new Object[0])).func_150258_a(" " + (float)this.effectDuration / 20.0f);
        }
        return description;
    }

    @Override
    public ITextComponent getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent summary = this.getEffectTypeName().func_150258_a(" (" + this.effectTarget + ")");
        if (this.effectStrength > 0) {
            summary.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("entity.level", new Object[0])).func_150258_a(" " + this.effectStrength);
        }
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            summary.func_150258_a(" " + (float)this.effectDuration / 20.0f);
        }
        return summary;
    }

    public ITextComponent getEffectTypeName() {
        if ("burning".equals(this.effectType)) {
            return new TranslationTextComponent("effect.burning", new Object[0]);
        }
        Effect effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(this.effectType));
        if (effect == null) {
            return new StringTextComponent(this.effectType);
        }
        return effect.func_199286_c();
    }

    public void onHitEntity(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (target == null || attacker == null) {
            return;
        }
        LivingEntity effectTarget = target;
        if ("self".equalsIgnoreCase(this.effectTarget)) {
            effectTarget = attacker;
        }
        if ("burning".equalsIgnoreCase(this.effectType)) {
            effectTarget.func_70015_d(Math.round((float)this.effectDuration / 20.0f));
            return;
        }
        Effect effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(this.effectType));
        if (effect != null && this.effectStrength > 0) {
            effectTarget.func_195064_c(new EffectInstance(effect, this.effectDuration, this.effectStrength - 1));
        }
    }
}

