/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.BaseItem;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEquipmentPart
extends BaseItem {
    public static Map<String, List<ItemEquipmentPart>> MOB_PART_DROPS = new HashMap<String, List<ItemEquipmentPart>>();
    public List<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
    public String slotType;
    public String dropMobId;
    public float dropChance = 1.0f;
    public int levelMin = 1;
    public int levelMax = 3;

    public ItemEquipmentPart(Item.Properties properties, ModInfo groupInfo) {
        super(properties);
        this.modInfo = groupInfo;
    }

    public void loadFromJSON(JsonObject json) {
        this.itemName = "equipmentpart_" + json.get("itemName").getAsString();
        this.slotType = json.get("slotType").getAsString();
        if (json.has("dropMobId")) {
            this.dropMobId = json.get("dropMobId").getAsString();
            if (!"".equals(this.dropMobId)) {
                if (!MOB_PART_DROPS.containsKey(this.dropMobId)) {
                    MOB_PART_DROPS.put(this.dropMobId, new ArrayList());
                }
                MOB_PART_DROPS.get(this.dropMobId).add(this);
            }
        }
        if (json.has("dropChance")) {
            this.dropChance = json.get("dropChance").getAsFloat();
        }
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
        if (json.has("features")) {
            JsonArray jsonArray = json.get("features").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject featureJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                if (this.addFeature(EquipmentFeature.createFromJSON(featureJson))) continue;
                LycanitesMobs.logWarning("", "[Equipment] The feature " + featureJson.toString() + " was unable to be added, check the JSON format.");
            }
        }
        this.sortFeatures();
        this.setup();
        TextureManager.addTexture(this.itemName, this.modInfo, "textures/equipment/" + this.itemName + ".png");
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        TranslationTextComponent displayName = new TranslationTextComponent(this.func_77667_c(itemStack).replace("equipmentpart_", ""), new Object[0]);
        displayName.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.level", new Object[0])).func_150258_a(" " + this.getLevel(itemStack));
        return displayName;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (ITextComponent description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("-------------------\n" + description.func_150254_d(), DESCRIPTION_WIDTH);
            for (String formattedDescription : formattedDescriptionList) {
                tooltip.add((ITextComponent)new StringTextComponent(formattedDescription));
            }
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        return new TranslationTextComponent("item.equipmentpart.description", new Object[0]);
    }

    public List<ITextComponent> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<ITextComponent> descriptions = new ArrayList<ITextComponent>();
        int level = this.getLevel(itemStack);
        ITextComponent baseFeature = new TranslationTextComponent("equipment.slottype", new Object[0]).func_150258_a(" " + this.slotType).func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.level", new Object[0])).func_150258_a(" " + level + "/" + this.levelMax);
        descriptions.add(baseFeature);
        for (EquipmentFeature feature : this.features) {
            ITextComponent featureDescription = feature.getDescription(itemStack, level);
            if (featureDescription == null || "".equals(featureDescription.func_150254_d())) continue;
            descriptions.add(featureDescription);
        }
        return descriptions;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public CompoundNBT getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new CompoundNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientManager.getInstance().getFontRenderer();
    }

    public void initializePart(World world, ItemStack itemStack) {
        int level = this.levelMax;
        if (this.levelMin < this.levelMax) {
            level = this.levelMin + world.field_73012_v.nextInt(this.levelMax - this.levelMin + 1);
        }
        this.setLevel(itemStack, level);
    }

    public boolean addFeature(EquipmentFeature feature) {
        if (feature == null) {
            LycanitesMobs.logWarning("", "[Equipment] Unable to add a null feature to " + (Object)((Object)this));
            return false;
        }
        if (feature.featureType == null) {
            LycanitesMobs.logWarning("", "[Equipment] Feature type not set for part " + (Object)((Object)this));
            return false;
        }
        this.features.add(feature);
        return true;
    }

    public void sortFeatures() {
        Comparator comparator = (o1, o2) -> o1.featureType.compareToIgnoreCase(o2.featureType);
        this.features.sort(comparator);
    }

    public void setLevel(ItemStack itemStack, int level) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        if (!nbt.func_74764_b("equipmentLevel")) {
            nbt.func_74768_a("equipmentLevel", level);
        }
        itemStack.func_77982_d(nbt);
    }

    public int getLevel(ItemStack itemStack) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        int level = 1;
        if (nbt.func_74764_b("equipmentLevel")) {
            level = nbt.func_74762_e("equipmentLevel");
        }
        return level;
    }

    public Vec3d getColor(ItemStack itemStack) {
        CompoundNBT nbt = this.getTagCompound(itemStack);
        double r = 1.0;
        double g = 1.0;
        double b = 1.0;
        if (nbt.func_74764_b("equipmentColorR")) {
            r = nbt.func_74760_g("equipmentColorR");
        }
        if (nbt.func_74764_b("equipmentColorG")) {
            g = nbt.func_74760_g("equipmentColorG");
        }
        if (nbt.func_74764_b("equipmentColorB")) {
            b = nbt.func_74760_g("equipmentColorB");
        }
        return new Vec3d(r, g, b);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int level = 1; level <= this.levelMax; ++level) {
            ItemStack itemStack = new ItemStack((IItemProvider)this, 1);
            this.setLevel(itemStack, level);
            items.add((Object)itemStack);
        }
    }
}

