/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.item.BaseItem;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.item.equipment.features.DamageEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EffectEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.HarvestEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.ProjectileEquipmentFeature;
import com.lycanitesmobs.core.item.equipment.features.SummonEquipmentFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemEquipment
extends BaseItem {
    public static int PART_LIMIT = 20;

    public ItemEquipment(Item.Properties properties) {
        super(properties);
        this.itemName = "equipment";
        this.modInfo = LycanitesMobs.modInfo;
        this.setRegistryName(this.modInfo.modid, this.itemName);
        properties.func_200917_a(1);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (ITextComponent description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c("" + description.func_150254_d(), DESCRIPTION_WIDTH);
            for (String formattedDescription : formattedDescriptionList) {
                tooltip.add((ITextComponent)new StringTextComponent(formattedDescription));
            }
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        return new TranslationTextComponent("item.equipment.description", new Object[0]);
    }

    public List<ITextComponent> getAdditionalDescriptions(ItemStack itemStack, @Nullable World world, ITooltipFlag tooltipFlag) {
        ArrayList<ITextComponent> descriptions = new ArrayList<ITextComponent>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(itemStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            int partLevel = equipmentPart.getLevel(equipmentPartStack);
            descriptions.add(equipmentPart.func_200295_i(itemStack).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("entity.level", new Object[0])).func_150258_a(" " + partLevel));
        }
        descriptions.add((ITextComponent)new StringTextComponent("-------------------\n"));
        ITextComponent damageDescription = new TranslationTextComponent("equipment.feature.damage", new Object[0]).func_150258_a(" " + String.format("%.0f", this.getDamageAmount(itemStack) + 1.0));
        damageDescription.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.cooldown", new Object[0])).func_150258_a(" " + String.format("%.1f", this.getDamageCooldown(itemStack)));
        damageDescription.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.knockback", new Object[0])).func_150258_a(" " + String.format("%.0f", this.getDamageKnockback(itemStack)));
        damageDescription.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.range", new Object[0])).func_150258_a(" " + String.format("%.1f", this.getDamageRange(itemStack)));
        damageDescription.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.sweep", new Object[0])).func_150258_a(" " + String.format("%.0f", Math.min(this.getDamageSweep(itemStack), 360.0)));
        descriptions.add(damageDescription);
        ITextComponent harvestSummaries = this.getFeatureSummaries(itemStack, "harvest");
        ITextComponent effectSummaries = this.getFeatureSummaries(itemStack, "effect");
        ITextComponent projectileSummaries = this.getFeatureSummaries(itemStack, "projectile");
        ITextComponent summonSummaries = this.getFeatureSummaries(itemStack, "summon");
        if (!("".equals(harvestSummaries.func_150254_d()) && "".equals(effectSummaries.func_150254_d()) && "".equals(projectileSummaries.func_150254_d()) && "".equals(summonSummaries.func_150254_d()))) {
            descriptions.add((ITextComponent)new StringTextComponent("-------------------\n"));
            if (!"".equals(harvestSummaries.func_150254_d())) {
                descriptions.add(new TranslationTextComponent("equipment.feature.harvest", new Object[0]).func_150258_a(" ").func_150257_a(harvestSummaries));
            }
            if (!"".equals(effectSummaries.func_150254_d())) {
                descriptions.add(new TranslationTextComponent("equipment.feature.effect", new Object[0]).func_150258_a(" ").func_150257_a(effectSummaries));
            }
            if (!"".equals(projectileSummaries.func_150254_d())) {
                descriptions.add(new TranslationTextComponent("equipment.feature.projectile", new Object[0]).func_150258_a(" ").func_150257_a(projectileSummaries));
            }
            if (!"".equals(summonSummaries.func_150254_d())) {
                descriptions.add(new TranslationTextComponent("equipment.feature.summon", new Object[0]).func_150258_a(" ").func_150257_a(summonSummaries));
            }
        }
        return descriptions;
    }

    public ITextComponent getFeatureSummaries(ItemStack itemStack, String featureType) {
        Map<EquipmentFeature, ItemStack> effectFeatures = this.getFeaturesByTypeWithPartStack(itemStack, featureType);
        StringTextComponent featureSummaries = new StringTextComponent("");
        boolean first = true;
        for (EquipmentFeature equipmentFeature : effectFeatures.keySet()) {
            if (!first) {
                featureSummaries.func_150258_a(", ");
            }
            first = false;
            ITextComponent featureSummary = equipmentFeature.getSummary(effectFeatures.get(equipmentFeature), this.getPartLevel(effectFeatures.get(equipmentFeature)));
            if (featureSummary == null) continue;
            featureSummaries.func_150257_a(featureSummary);
        }
        return featureSummaries;
    }

    public CompoundNBT getTagCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p();
        }
        return new CompoundNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientManager.getInstance().getFontRenderer();
    }

    public NonNullList<ItemStack> getEquipmentPartStacks(ItemStack itemStack) {
        NonNullList itemStacks = NonNullList.func_191197_a((int)PART_LIMIT, (Object)ItemStack.field_190927_a);
        CompoundNBT nbt = this.getTagCompound(itemStack);
        if (nbt.func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)itemStacks);
        }
        return itemStacks;
    }

    public int getEquipmentPartCount(ItemStack itemStack) {
        int partCount = 0;
        for (ItemStack partStack : this.getEquipmentPartStacks(itemStack)) {
            if (partStack.func_190926_b()) continue;
            ++partCount;
        }
        return partCount;
    }

    public ItemEquipmentPart getEquipmentPart(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (!(itemStack.func_77973_b() instanceof ItemEquipmentPart)) {
            return null;
        }
        return (ItemEquipmentPart)itemStack.func_77973_b();
    }

    public void addEquipmentPart(ItemStack equipmentStack, ItemStack equipmentPartStack, int slotIndex) {
        if (slotIndex >= PART_LIMIT) {
            return;
        }
        NonNullList<ItemStack> itemStacks = this.getEquipmentPartStacks(equipmentStack);
        itemStacks.set(slotIndex, (Object)equipmentPartStack);
        CompoundNBT nbt = this.getTagCompound(equipmentStack);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, itemStacks);
        equipmentStack.func_77982_d(nbt);
    }

    public List<EquipmentFeature> getFeaturesByType(ItemStack equipmentStack, String featureType) {
        ArrayList<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            for (EquipmentFeature feature : equipmentPart.features) {
                if (!feature.isActive(equipmentPartStack, equipmentPart.getLevel(equipmentPartStack)) || !feature.featureType.equalsIgnoreCase(featureType)) continue;
                features.add(feature);
            }
        }
        return features;
    }

    public Map<EquipmentFeature, ItemStack> getFeaturesByTypeWithPartStack(ItemStack equipmentStack, String featureType) {
        HashMap<EquipmentFeature, ItemStack> features = new HashMap<EquipmentFeature, ItemStack>();
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            for (EquipmentFeature feature : equipmentPart.features) {
                if (!feature.isActive(equipmentPartStack, equipmentPart.getLevel(equipmentPartStack)) || !feature.featureType.equalsIgnoreCase(featureType)) continue;
                features.put(feature, equipmentPartStack);
            }
        }
        return features;
    }

    public void applyLevelCap(ItemStack equipmentStack, int levelCap) {
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null) continue;
            equipmentPart.setLevel(equipmentPartStack, Math.min(levelCap, equipmentPart.getLevel(equipmentPartStack)));
        }
    }

    public int getHighestLevel(ItemStack equipmentStack) {
        int highestLevel = 0;
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipmentStack)) {
            int partLevel;
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null || (partLevel = equipmentPart.getLevel(equipmentPartStack)) <= highestLevel) continue;
            highestLevel = partLevel;
        }
        return highestLevel;
    }

    public int getPartLevel(ItemStack partStack) {
        Item featureItem = partStack.func_77973_b();
        if (!(featureItem instanceof ItemEquipmentPart)) {
            return 1;
        }
        ItemEquipmentPart featurePart = (ItemEquipmentPart)featureItem;
        return featurePart.getLevel(partStack);
    }

    @Override
    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 1800;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        boolean active = false;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            if (!projectileFeature.onUseSecondary(world, player, hand)) continue;
            active = true;
        }
        if (active) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.PASS, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
    }

    @Override
    public void onUsingTick(ItemStack itemStack, LivingEntity user, int count) {
        if (!user.func_184587_cr()) {
            return;
        }
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
            ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
            projectileFeature.onHoldSecondary(user, count);
        }
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack itemStack) {
        HashMap<ToolType, Boolean> toolTypes = new HashMap<ToolType, Boolean>();
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            ToolType toolType = harvestFeature.getToolType();
            if (toolType == null) continue;
            toolTypes.put(toolType, true);
        }
        return toolTypes.keySet();
    }

    public int getHarvestLevel(ItemStack itemStack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        int harvestLevel = -1;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (harvestLevel >= harvestFeature.harvestLevel || tool != harvestFeature.getToolType()) continue;
            harvestLevel = harvestFeature.harvestLevel;
        }
        return harvestLevel;
    }

    public boolean canHarvestBlock(ItemStack itemStack, BlockState blockState) {
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            if (!harvestFeature.canHarvestBlock(blockState)) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        float speed = 1.0f;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
            HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
            speed += harvestFeature.getHarvestSpeed(blockState);
        }
        return speed;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, BlockState blockState, BlockPos pos, LivingEntity entityLiving) {
        if (!world.field_72995_K) {
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "harvest")) {
                HarvestEquipmentFeature harvestFeature = (HarvestEquipmentFeature)equipmentFeature;
                harvestFeature.onBlockDestroyed(world, blockState, pos, entityLiving);
            }
        }
        return super.func_179218_a(itemStack, world, blockState, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity primaryTarget, LivingEntity attacker) {
        double sweepAngle;
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(primaryTarget);
        if (attacker != null && !attacker.func_130014_f_().field_72995_K && (sweepAngle = this.getDamageSweep(itemStack)) > 0.0) {
            float sweepDamage = (float)this.getDamageAmount(itemStack);
            double sweepRange = 1.0 + this.getDamageRange(itemStack);
            List possibleTargets = attacker.func_130014_f_().func_217357_a(LivingEntity.class, attacker.func_174813_aQ().func_72314_b(sweepRange, sweepRange, sweepRange));
            for (LivingEntity possibleTarget : possibleTargets) {
                double targetZDist;
                Object possibleTameableTarget;
                if (possibleTarget == attacker || possibleTarget == primaryTarget || !possibleTarget.func_70089_S() || possibleTarget instanceof TameableEntity && ((possibleTameableTarget = (TameableEntity)possibleTarget).func_70902_q() != null && !attacker.func_130014_f_().func_73046_m().func_71219_W() || possibleTameableTarget.func_70902_q() == attacker) || possibleTarget instanceof TameableCreatureEntity && (((TameableCreatureEntity)((Object)(possibleTameableTarget = (TameableCreatureEntity)possibleTarget))).getPlayerOwner() != null && !attacker.func_130014_f_().func_73046_m().func_71219_W() || ((TameableCreatureEntity)((Object)possibleTameableTarget)).getPlayerOwner() == attacker)) continue;
                double targetXDist = possibleTarget.func_213303_ch().func_82615_a() - attacker.func_213303_ch().func_82615_a();
                double targetAngleAbsolute = 180.0 + Math.toDegrees(Math.atan2(targetXDist, targetZDist = attacker.func_213303_ch().func_82616_c() - possibleTarget.func_213303_ch().func_82616_c()));
                double targetAngle = Math.abs(targetAngleAbsolute - (double)attacker.field_70177_z);
                if (targetAngle > 180.0) {
                    targetAngle = 180.0 - (targetAngle - 180.0);
                }
                if (targetAngle > sweepAngle) continue;
                targets.add(possibleTarget);
                DamageSource sweepSource = DamageSource.field_76377_j;
                if (attacker instanceof PlayerEntity) {
                    sweepSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
                }
                possibleTarget.func_70097_a(sweepSource, sweepDamage);
            }
        }
        if (attacker instanceof PlayerEntity && targets.size() > 1) {
            PlayerEntity playerAttacker = (PlayerEntity)attacker;
            playerAttacker.func_184810_cG();
            attacker.func_130014_f_().func_184148_a(null, attacker.func_213303_ch().func_82615_a(), attacker.func_213303_ch().func_82617_b(), attacker.func_213303_ch().func_82616_c(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
        }
        for (LivingEntity target : targets) {
            double knockback = this.getDamageKnockback(itemStack);
            if (knockback != 0.0 && attacker != null && target != null) {
                double xDist = attacker.func_213303_ch().func_82615_a() - target.func_213303_ch().func_82615_a();
                double zDist = attacker.func_213303_ch().func_82616_c() - target.func_213303_ch().func_82616_c();
                double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                double motionCap = 10.0;
                if (target.func_213322_ci().func_82615_a() < motionCap && target.func_213322_ci().func_82615_a() > -motionCap && target.func_213322_ci().func_82616_c() < motionCap && target.func_213322_ci().func_82616_c() > -motionCap) {
                    target.func_70024_g(-(xDist / xzDist * knockback + target.func_213322_ci().func_82615_a() * knockback), 0.0, -(zDist / xzDist * knockback + target.func_213322_ci().func_82616_c() * knockback));
                }
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "effect")) {
                EffectEquipmentFeature effectFeature = (EffectEquipmentFeature)equipmentFeature;
                effectFeature.onHitEntity(itemStack, target, attacker);
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "summon")) {
                SummonEquipmentFeature summonFeature = (SummonEquipmentFeature)equipmentFeature;
                summonFeature.onHitEntity(itemStack, target, attacker);
            }
            for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "projectile")) {
                ProjectileEquipmentFeature projectileFeature = (ProjectileEquipmentFeature)equipmentFeature;
                projectileFeature.onHitEntity(itemStack, target, attacker);
            }
        }
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, itemStack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageAmount(itemStack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -this.getDamageCooldown(itemStack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageAmount(ItemStack itemStack) {
        double damage = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            damage += (double)damageFeature.damageAmount;
        }
        return damage;
    }

    public double getDamageCooldown(ItemStack itemStack) {
        double cooldown = 0.0;
        double i = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            cooldown += damageFeature.damageCooldown;
            i += 1.0;
        }
        if (i == 0.0) {
            return 2.4;
        }
        cooldown = 2.4 * (cooldown / i);
        return Math.min(3.5, cooldown);
    }

    public double getDamageRange(ItemStack itemStack) {
        double range = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            range += damageFeature.damageRange;
        }
        return range;
    }

    public double getDamageKnockback(ItemStack itemStack) {
        double knockback = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            knockback += damageFeature.damageKnockback;
        }
        return knockback;
    }

    public double getDamageSweep(ItemStack itemStack) {
        double sweep = 0.0;
        for (EquipmentFeature equipmentFeature : this.getFeaturesByType(itemStack, "damage")) {
            DamageEquipmentFeature damageFeature = (DamageEquipmentFeature)equipmentFeature;
            sweep += damageFeature.damageSweep;
        }
        return sweep;
    }

    public ResourceLocation getTexture(ItemStack itemStack) {
        return TextureManager.getTexture(this.itemName);
    }
}

