/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.renderer.EquipmentPartRenderer;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;

public class EquipmentPartManager
extends JSONLoader {
    public static EquipmentPartManager INSTANCE;
    public Map<String, ItemEquipmentPart> equipmentParts = new HashMap<String, ItemEquipmentPart>();
    public List<ModInfo> loadedGroups = new ArrayList<ModInfo>();

    public static EquipmentPartManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EquipmentPartManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJson(ModInfo modInfo) {
        if (!this.loadedGroups.contains(modInfo)) {
            this.loadedGroups.add(modInfo);
        }
        this.loadAllJson(modInfo, "Equipment", "equipment", "itemName", false, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Equipment", "Complete! " + this.equipmentParts.size() + " JSON Equipment Parts Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        Item.Properties properties = new Item.Properties().func_200917_a(1).setNoRepair().func_200916_a(ItemManager.getInstance().equipmentPartsGroup).setTEISR(() -> EquipmentPartRenderer::new);
        ItemEquipmentPart equipmentPart = new ItemEquipmentPart(properties, modInfo);
        equipmentPart.loadFromJSON(json);
        if (this.equipmentParts.containsKey(equipmentPart.itemName)) {
            LycanitesMobs.logWarning("", "[Equipment] Tried to add a Equipment Part with a name that is already in use: " + equipmentPart.itemName);
            throw new RuntimeException("[Equipment] Tried to add a Equipment Part with a name that is already in use: " + equipmentPart.itemName);
        }
        if (this.equipmentParts.values().contains((Object)equipmentPart)) {
            LycanitesMobs.logWarning("", "[Equipment] Tried to add a Equipment Part that is already added: " + equipmentPart.itemName);
            throw new RuntimeException("[Equipment] Tried to add a Equipment Part that is already added: " + equipmentPart.itemName);
        }
        this.equipmentParts.put(equipmentPart.itemName, equipmentPart);
        ObjectManager.addItem(equipmentPart.itemName, equipmentPart);
    }

    public void reload() {
        this.equipmentParts.clear();
        for (ModInfo group : this.loadedGroups) {
            this.loadAllFromJson(group);
        }
    }
}

